/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.client.models;

import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.model.SimpleModelState;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import tv.soaryn.xycraft.machines.client.models.PipeBakedModel;

public class PipeUnbakedGeometry
implements IUnbakedGeometry<PipeUnbakedGeometry> {
    private final BlockModel _straight;
    private final BlockModel _cap;
    private final BlockModel _core;
    private final BlockModel _extract;
    private final BlockModel _insert;
    private final BlockModel _short;

    public PipeUnbakedGeometry(BlockModel straight, BlockModel cap, BlockModel core, BlockModel extract, BlockModel insert, BlockModel shortStraight) {
        this._straight = straight;
        this._cap = cap;
        this._core = core;
        this._extract = extract;
        this._insert = insert;
        this._short = shortStraight;
    }

    public void resolveParents(@NotNull Function<ResourceLocation, UnbakedModel> modelGetter, @NotNull IGeometryBakingContext context) {
        if (this._straight != null) {
            this._straight.resolveParents(modelGetter);
        }
        this._cap.resolveParents(modelGetter);
        this._core.resolveParents(modelGetter);
        this._extract.resolveParents(modelGetter);
        this._insert.resolveParents(modelGetter);
        this._short.resolveParents(modelGetter);
    }

    @NotNull
    public BakedModel bake(@NotNull IGeometryBakingContext context, @NotNull ModelBaker baker, @NotNull Function<Material, TextureAtlasSprite> spriteGetter, @NotNull ModelState modelState, @NotNull ItemOverrides overrides) {
        BakedModel core = this._core.bake(baker, this._core, spriteGetter, modelState, true);
        Reference2ObjectOpenHashMap straight = new Reference2ObjectOpenHashMap();
        Reference2ObjectOpenHashMap<Direction, BakedModel> insert = this.mapBakedModels(baker, this._insert, spriteGetter);
        Reference2ObjectOpenHashMap<Direction, BakedModel> extract = this.mapBakedModels(baker, this._extract, spriteGetter);
        Reference2ObjectOpenHashMap<Direction, BakedModel> shortStraight = this.mapBakedModels(baker, this._short, spriteGetter);
        Reference2ObjectOpenHashMap<Direction, BakedModel> cap = this.mapBakedModels(baker, this._cap, spriteGetter);
        if (this._straight != null) {
            straight.put((Object)Direction.Axis.Y, (Object)this._straight.bake(baker, this._straight, spriteGetter, (ModelState)new SimpleModelState(Transformation.identity()), true));
            Transformation transform1 = new Transformation(new Vector3f(), new Quaternionf().rotateX(1.5707964f), new Vector3f(1.0f, 1.0f, 1.0f), new Quaternionf().identity());
            straight.put((Object)Direction.Axis.Z, (Object)this._straight.bake(baker, this._straight, spriteGetter, (ModelState)new SimpleModelState(transform1), true));
            Transformation transform2 = new Transformation(new Vector3f(), new Quaternionf().rotateZ(1.5707964f), new Vector3f(1.0f, 1.0f, 1.0f), new Quaternionf().identity());
            straight.put((Object)Direction.Axis.X, (Object)this._straight.bake(baker, this._straight, spriteGetter, (ModelState)new SimpleModelState(transform2), true));
        }
        return new PipeBakedModel(core, (Reference2ObjectMap<Direction.Axis, BakedModel>)straight, insert, extract, shortStraight, cap);
    }

    @NotNull
    private Reference2ObjectOpenHashMap<Direction, BakedModel> mapBakedModels(@NotNull ModelBaker baker, BlockModel model, @NotNull Function<Material, TextureAtlasSprite> spriteGetter) {
        return Direction.stream().collect(Collectors.toMap(Function.identity(), d -> {
            Transformation transform = new Transformation(new Vector3f(), d.getOpposite().getRotation(), new Vector3f(1.0f, 1.0f, 1.0f), new Quaternionf().identity());
            return model.bake(baker, model, spriteGetter, (ModelState)new SimpleModelState(transform), true);
        }, (bakedModel, bakedModel2) -> bakedModel, Reference2ObjectOpenHashMap::new));
    }
}

