/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.client.EnergyTooltipHelper;
import tv.soaryn.xycraft.machines.client.items.FoilItemModel;
import tv.soaryn.xycraft.machines.client.models.PipeModelLoader;
import tv.soaryn.xycraft.machines.client.multiblock.ClientTankEventHandler;
import tv.soaryn.xycraft.machines.client.render.GauntletRenderLayer;
import tv.soaryn.xycraft.machines.client.render.HoverPackArmorRenderLayer;
import tv.soaryn.xycraft.machines.client.render.MachinesModelBakery;
import tv.soaryn.xycraft.machines.client.render.blocks.BalloonStakeRender;
import tv.soaryn.xycraft.machines.client.render.blocks.FabricatorRender;
import tv.soaryn.xycraft.machines.client.render.blocks.FluidSelectorRender;
import tv.soaryn.xycraft.machines.client.render.blocks.ItemSelectorRender;
import tv.soaryn.xycraft.machines.client.render.blocks.NitrogenExtractorRender;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;
import tv.soaryn.xycraft.machines.content.registries.MachinesMenus;
import tv.soaryn.xycraft.machines.gui.BufferUI;
import tv.soaryn.xycraft.machines.gui.ChargerUI;
import tv.soaryn.xycraft.machines.gui.CollectorUI;
import tv.soaryn.xycraft.machines.gui.EngineeringTableUI;
import tv.soaryn.xycraft.machines.gui.FabricatorUI;
import tv.soaryn.xycraft.machines.gui.ProtoUI;
import tv.soaryn.xycraft.machines.gui.SoarynBoxUI;
import tv.soaryn.xycraft.machines.gui.TankUI;

public class XyMachinesClient {
    public static void init(FMLClientSetupEvent event) {
        ClientTankEventHandler.init();
    }

    @EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    static interface ModBus {
        @SubscribeEvent
        public static void onRegisterClientTooltipComponentFactories(RegisterClientTooltipComponentFactoriesEvent event) {
            event.register(EnergyTooltipHelper.XynergyConsumerTooltip.class, EnergyTooltipHelper.XynergyConsumerTooltipClient::new);
        }

        @SubscribeEvent
        public static void registerUI(RegisterMenuScreensEvent event) {
            event.register((MenuType)MachinesMenus.Fabricator.get(), FabricatorUI::new);
            event.register((MenuType)MachinesMenus.SoarynBox.get(), SoarynBoxUI::new);
            event.register((MenuType)MachinesMenus.Charger.get(), ChargerUI::new);
            event.register((MenuType)MachinesMenus.Tank.get(), TankUI::new);
            event.register((MenuType)MachinesMenus.Collector.get(), CollectorUI::new);
            event.register((MenuType)MachinesMenus.Buffer.get(), BufferUI::new);
            event.register((MenuType)MachinesMenus.EngineeringTable.get(), EngineeringTableUI::new);
            event.register((MenuType)MachinesMenus.Proto.get(), ProtoUI::new);
        }

        @SubscribeEvent
        public static void registerModelLoaders(ModelEvent.RegisterGeometryLoaders event) {
            event.register(XyMachines.resource("foil"), (IGeometryLoader)new FoilItemModel.Loader());
            event.register(XyMachines.resource("pipe"), (IGeometryLoader)new PipeModelLoader());
        }

        @SubscribeEvent
        public static void onRegisterRenderer(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer(MachinesContent.Block.ItemSelector.entity(), ItemSelectorRender::new);
            event.registerBlockEntityRenderer(MachinesContent.Block.FluidSelector.entity(), FluidSelectorRender::new);
            event.registerBlockEntityRenderer(MachinesContent.Block.Fabricator.entity(), FabricatorRender::new);
            event.registerBlockEntityRenderer(MachinesContent.Block.Stake.entity(), BalloonStakeRender::new);
            event.registerBlockEntityRenderer(MachinesContent.Block.NitrogenExtractor.entity(), NitrogenExtractorRender::new);
        }

        @SubscribeEvent
        public static void registerAdditionalModels(ModelEvent.RegisterAdditional event) {
            event.register(MachinesModelBakery.NitrogenExtractorResource);
            event.register(MachinesModelBakery.BalloonResource);
        }

        @SubscribeEvent
        public static void onBakingCompleted(ModelEvent.BakingCompleted event) {
            MachinesModelBakery.init(event);
        }

        @SubscribeEvent
        public static void addLayers(EntityRenderersEvent.AddLayers event) {
            EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
            HoverPackArmorRenderLayer.registerOnAll(dispatcher);
            GauntletRenderLayer.registerOnAll(dispatcher);
        }
    }
}

