/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.worldgen.structure;

import com.dtteam.dynamictrees.worldgen.structure.DTCancelVanillaTreePoolElement;
import com.dtteam.dynamictrees.worldgen.structure.TemplatePoolModifier;
import com.mojang.datafixers.util.Pair;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class RegularTemplatePoolModifier
implements TemplatePoolModifier {
    private final ResourceKey<StructureTemplatePool> key;
    private final StructureTemplatePool templatePool;

    private RegularTemplatePoolModifier(ResourceKey<StructureTemplatePool> key, StructureTemplatePool templatePool) {
        this.key = key;
        this.templatePool = templatePool;
    }

    @Override
    public TemplatePoolModifier replaceTemplate(int index, StructurePoolElement element) {
        if (this.templatePool.rawTemplates.size() <= index) {
            return this;
        }
        Pair removedRawTemplate = (Pair)this.templatePool.rawTemplates.remove(index);
        DTCancelVanillaTreePoolElement elementFinal = new DTCancelVanillaTreePoolElement(element, (StructurePoolElement)removedRawTemplate.getFirst());
        this.templatePool.rawTemplates.add(index, Pair.of((Object)((Object)elementFinal), (Object)((Integer)removedRawTemplate.getSecond())));
        this.templatePool.templates.replaceAll(template -> {
            if (template == removedRawTemplate.getFirst()) {
                return elementFinal;
            }
            return template;
        });
        return this;
    }

    @Override
    public TemplatePoolModifier removeTemplate(int index) {
        Pair removedRawTemplate = (Pair)this.templatePool.rawTemplates.remove(index);
        this.templatePool.templates.removeIf(template -> template == removedRawTemplate.getFirst());
        return this;
    }

    @Override
    public void removeAllTemplates() {
        this.templatePool.rawTemplates.clear();
        this.templatePool.templates.clear();
    }

    @Override
    public void registerPool(BootstrapContext<StructureTemplatePool> context) {
        context.register(this.key, (Object)this.templatePool);
    }

    public static TemplatePoolModifier village(HolderLookup.Provider lookupProvider, String type, String patternGroup) {
        ResourceLocation patternName = ResourceLocation.parse((String)("village/" + type + "/" + patternGroup));
        return RegularTemplatePoolModifier.create(lookupProvider, (ResourceKey<StructureTemplatePool>)ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)patternName));
    }

    public static TemplatePoolModifier create(HolderLookup.Provider lookupProvider, ResourceKey<StructureTemplatePool> key) {
        StructureTemplatePool pattern = (StructureTemplatePool)lookupProvider.lookupOrThrow(Registries.TEMPLATE_POOL).getOrThrow(key).value();
        return new RegularTemplatePoolModifier(key, new StructureTemplatePool(pattern.getFallback(), pattern.rawTemplates));
    }
}

