/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.worldgen.featurecancellation;

import com.dtteam.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.dtteam.dynamictrees.api.worldgen.FeatureCanceller;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomBooleanFeatureConfiguration;

public class MushroomFeatureCanceller<T extends FeatureConfiguration>
extends FeatureCanceller {
    private final Class<T> mushroomFeatureConfigClass;

    public MushroomFeatureCanceller(ResourceLocation registryName, Class<T> mushroomFeatureConfigClass) {
        super(registryName);
        this.mushroomFeatureConfigClass = mushroomFeatureConfigClass;
    }

    @Override
    public boolean shouldCancel(ConfiguredFeature<?, ?> configuredFeature, BiomePropertySelectors.NormalFeatureCancellation featureCancellations) {
        ResourceLocation featureRegistryName = BuiltInRegistries.FEATURE.getKey((Object)configuredFeature.feature());
        if (featureRegistryName == null) {
            return false;
        }
        FeatureConfiguration featureConfiguration = configuredFeature.config();
        if (!(featureConfiguration instanceof RandomBooleanFeatureConfiguration)) {
            return false;
        }
        RandomBooleanFeatureConfiguration randomBooleanFeatureConfiguration = (RandomBooleanFeatureConfiguration)featureConfiguration;
        return this.getConfigs(randomBooleanFeatureConfiguration).anyMatch(this.mushroomFeatureConfigClass::isInstance) && featureCancellations.shouldCancelNamespace(featureRegistryName.getNamespace());
    }

    private Stream<FeatureConfiguration> getConfigs(RandomBooleanFeatureConfiguration twoFeatureConfig) {
        return twoFeatureConfig.getFeatures().map(ConfiguredFeature::config);
    }
}

