/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.tree.species;

import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.worldgen.DynamicTreeGenerationContext;
import com.mojang.datafixers.util.Function3;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class SwampSpecies
extends Species {
    public static final TypedRegistry.EntryType<Species> TYPE = SwampSpecies.createDefaultType((Function3<ResourceLocation, Family, LeavesProperties, Species>)((Function3)SwampSpecies::new));
    private static final int minRadiusForSunkGeneration = 5;

    public SwampSpecies(ResourceLocation name, Family family, LeavesProperties leavesProperties) {
        super(name, family, leavesProperties);
    }

    @Override
    public boolean generate(DynamicTreeGenerationContext context) {
        if (this.isWater(context.level().getBlockState((BlockPos)context.rootPos()))) {
            switch (Services.CONFIG.getEnumConfig("swampOaksInWater", WaterSurfaceGenerationState.class).ordinal()) {
                case 1: {
                    if (context.radius() >= 5) {
                        context.rootPos().move(Direction.DOWN, this.countWaterBlocksBelow(context.level(), (BlockPos)context.rootPos(), this.getAllowedWaterHeightForWorldgen()));
                        break;
                    }
                    return false;
                }
                case 2: {
                    return false;
                }
            }
        }
        return super.generate(context);
    }

    public static enum WaterSurfaceGenerationState {
        ROOTED,
        SUNK,
        DISABLED;

    }
}

