/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.tree;

import com.dtteam.dynamictrees.api.network.BranchDestructionData;
import com.dtteam.dynamictrees.api.network.MapSignal;
import com.dtteam.dynamictrees.api.treedata.TreePart;
import com.dtteam.dynamictrees.api.voxmap.SimpleVoxmap;
import com.dtteam.dynamictrees.block.Ageable;
import com.dtteam.dynamictrees.block.NullTreePart;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.branch.TrunkShellBlock;
import com.dtteam.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.dtteam.dynamictrees.block.soil.SoilBlock;
import com.dtteam.dynamictrees.block.soil.SoilBlockDecayer;
import com.dtteam.dynamictrees.client.ParticleHelper;
import com.dtteam.dynamictrees.systems.nodemapper.TwinkleNode;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.worldgen.JoCode;
import com.dtteam.dynamictrees.worldgen.RootsJoCode;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TreeHelper {
    public static final TreePart NULL_TREE_PART = new NullTreePart();

    public static void growPulse(Level level, BlockPos rootPos) {
        BlockState rootyState = level.getBlockState(rootPos);
        SoilBlock dirt = TreeHelper.getRooty(rootyState);
        if (dirt != null) {
            dirt.updateTree(rootyState, level, rootPos, level.random, false);
            TreeHelper.ageVolume((LevelAccessor)level, rootPos, 8, 32, 1, false);
        }
    }

    public static void ageVolume(LevelAccessor level, SimpleVoxmap leafMap, int iterations, boolean worldgen) {
        if (leafMap == null) {
            return;
        }
        SimpleVoxmap iterMap = new SimpleVoxmap(leafMap);
        for (int i = 0; i < iterations; ++i) {
            for (BlockPos.MutableBlockPos iPos : iterMap.getAllNonZero()) {
                BlockState blockState = level.getBlockState((BlockPos)iPos);
                Block block = blockState.getBlock();
                if (block instanceof DynamicLeavesBlock) {
                    byte prevHydro = leafMap.getVoxel((BlockPos)iPos);
                    int newHydro = ((Ageable)block).age(level, (BlockPos)iPos, blockState, level.getRandom(), worldgen);
                    if (newHydro == -1) {
                        leafMap.setVoxel((BlockPos)iPos, (byte)0);
                        iterMap.setVoxel((BlockPos)iPos, (byte)0);
                        continue;
                    }
                    if (prevHydro == newHydro) {
                        iterMap.setVoxel((BlockPos)iPos, (byte)0);
                        continue;
                    }
                    leafMap.setVoxel((BlockPos)iPos, (byte)newHydro);
                    iterMap.setVoxel((BlockPos)iPos, (byte)newHydro);
                    for (Direction dir : Direction.values()) {
                        BlockPos dPos = iPos.relative(dir);
                        iterMap.setVoxel(dPos, leafMap.getVoxel(dPos));
                    }
                    continue;
                }
                if (block instanceof Ageable) {
                    ((Ageable)block).age(level, (BlockPos)iPos, blockState, level.getRandom(), worldgen);
                    continue;
                }
                leafMap.setVoxel((BlockPos)iPos, (byte)0);
                iterMap.setVoxel((BlockPos)iPos, (byte)0);
            }
        }
    }

    public static void ageVolume(LevelAccessor level, BlockPos treePos, int halfWidth, int height, int iterations, boolean worldgen) {
        Iterable iterable = BlockPos.betweenClosed((BlockPos)treePos.offset((Vec3i)new BlockPos(-halfWidth, 0, -halfWidth)), (BlockPos)treePos.offset((Vec3i)new BlockPos(halfWidth, height, halfWidth)));
        for (int i = 0; i < iterations; ++i) {
            for (BlockPos iPos : iterable) {
                BlockState blockState = level.getBlockState(iPos);
                Block block = blockState.getBlock();
                if (!(block instanceof Ageable)) continue;
                ((Ageable)block).age(level, iPos, blockState, level.getRandom(), worldgen);
            }
        }
    }

    public static Optional<JoCode> getRootsJoCode(Level level, BlockPos pos) {
        return TreeHelper.getJoCode(level, pos, Direction.SOUTH, true);
    }

    public static Optional<JoCode> getJoCode(Level level, BlockPos pos) {
        return TreeHelper.getJoCode(level, pos, Direction.SOUTH, false);
    }

    public static Optional<JoCode> getJoCode(Level level, BlockPos pos, Direction direction, boolean roots) {
        if (pos == null) {
            return Optional.empty();
        }
        BlockPos rootPos = TreeHelper.findRootNode(level, pos = TreeHelper.dereferenceTrunkShell(level, pos));
        return rootPos != BlockPos.ZERO ? Optional.of(roots ? new RootsJoCode(level, rootPos, direction) : new JoCode(level, rootPos, direction)) : Optional.empty();
    }

    public static BlockPos dereferenceTrunkShell(Level level, BlockPos pos) {
        TrunkShellBlock.ShellMuse muse;
        BlockState blockState = level.getBlockState(pos);
        if (blockState.getBlock() instanceof TrunkShellBlock && (muse = ((TrunkShellBlock)blockState.getBlock()).getMuse((BlockGetter)level, blockState, pos)) != null) {
            return muse.pos();
        }
        return pos;
    }

    public static Species getCommonSpecies(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos = TreeHelper.dereferenceTrunkShell(level, pos));
        if (state.getBlock() instanceof BranchBlock) {
            BranchBlock branch = (BranchBlock)state.getBlock();
            return branch.getFamily().getCommonSpecies();
        }
        return Species.NULL_SPECIES;
    }

    public static Species getExactSpecies(Level level, BlockPos pos) {
        BlockPos rootPos = TreeHelper.findRootNode(level, pos);
        if (rootPos != BlockPos.ZERO) {
            BlockState rootyState = level.getBlockState(rootPos);
            return TreeHelper.getRooty(rootyState).getSpecies(rootyState, (LevelAccessor)level, rootPos);
        }
        return Species.NULL_SPECIES;
    }

    public static Species getBestGuessSpecies(Level level, BlockPos pos) {
        Species species = TreeHelper.getExactSpecies(level, pos);
        return species == Species.NULL_SPECIES ? TreeHelper.getCommonSpecies(level, pos) : species;
    }

    public static BlockPos findRootNode(Level level, BlockPos pos) {
        pos = TreeHelper.dereferenceTrunkShell(level, pos);
        BlockState state = level.getBlockState(pos);
        TreePart treePart = TreeHelper.getTreePart(level.getBlockState(pos));
        switch (treePart.getTreePartType()) {
            case BRANCH: {
                MapSignal signal = treePart.analyse(state, (LevelAccessor)level, pos, null, new MapSignal());
                if (!signal.foundRoot) break;
                return signal.root;
            }
            case ROOT: {
                return pos;
            }
            default: {
                return BlockPos.ZERO;
            }
        }
        return BlockPos.ZERO;
    }

    public static void setCustomRootBlockDecay(SoilBlockDecayer decay) {
        SoilBlock.soilBlockDecayer = decay;
    }

    public static SoilBlockDecayer getCustomRootBlockDecay() {
        return SoilBlock.soilBlockDecayer;
    }

    public static void treeParticles(Level level, BlockPos rootPos, SimpleParticleType type, int num) {
        if (level.isClientSide) {
            TreeHelper.startAnalysisFromRoot((LevelAccessor)level, rootPos, new MapSignal(new TwinkleNode(type, num)));
        }
    }

    public static void rootParticles(Level level, BlockPos rootPos, Direction offset, SimpleParticleType type, int num) {
        if (level.isClientSide && level.isClientSide() && level.getBlockState(rootPos).getBlock() instanceof SoilBlock) {
            BlockPos particlePos = rootPos.offset(offset.getNormal());
            ParticleHelper.spawnParticles((LevelAccessor)level, type, particlePos.getX(), particlePos.getY(), particlePos.getZ(), num, level.getRandom());
        }
    }

    public static boolean startAnalysisFromRoot(LevelAccessor level, BlockPos rootPos, MapSignal signal) {
        SoilBlock dirt = TreeHelper.getRooty(level.getBlockState(rootPos));
        if (dirt != null) {
            dirt.startAnalysis(level, rootPos, signal);
            return true;
        }
        return false;
    }

    public static void destroyTree(Level level, BlockPos cutPos, @Nullable Player player, BiConsumer<BlockPos, ItemStack> dropConsumer) {
        BlockPos startPos = TreeHelper.dereferenceTrunkShell(level, cutPos);
        BranchBlock cutBlock = TreeHelper.getBranch(level.getBlockState(startPos));
        level.levelEvent(null, 2001, cutPos, Block.getId((BlockState)level.getBlockState(cutPos)));
        BranchDestructionData destructionData = cutBlock.destroyBranchFromNode(level, cutPos, Direction.DOWN, false, (LivingEntity)player);
        destructionData.leavesDrops.forEach(stackData -> dropConsumer.accept(stackData.pos, stackData.stack));
        destructionData.species.getBranchesDrops(level, destructionData.woodVolume).forEach(stack -> dropConsumer.accept(startPos, (ItemStack)stack));
    }

    public static boolean isTreePart(Block block) {
        return block instanceof TreePart;
    }

    public static boolean isTreePart(BlockState state) {
        return TreeHelper.isTreePart(state.getBlock());
    }

    public static boolean isTreePart(LevelAccessor level, BlockPos pos) {
        return TreeHelper.isTreePart(level.getBlockState(pos).getBlock());
    }

    public static TreePart getTreePart(Block block) {
        return TreeHelper.isTreePart(block) ? (TreePart)block : NULL_TREE_PART;
    }

    public static TreePart getTreePart(BlockState state) {
        return TreeHelper.getTreePart(state.getBlock());
    }

    public static boolean isBranch(Block block) {
        return block instanceof BranchBlock;
    }

    public static boolean isBranch(@Nullable BlockState state) {
        return state != null && TreeHelper.isBranch(state.getBlock());
    }

    @Nullable
    public static BranchBlock getBranch(Block block) {
        return TreeHelper.isBranch(block) ? (BranchBlock)block : null;
    }

    @Nullable
    public static BranchBlock getBranch(TreePart treePart) {
        return treePart instanceof BranchBlock ? (BranchBlock)treePart : null;
    }

    @Nullable
    public static BranchBlock getBranch(BlockState state) {
        return TreeHelper.getBranch(state.getBlock());
    }

    public static int getRadius(BlockGetter level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        return TreeHelper.getTreePart(state).getRadius(state);
    }

    public static Optional<BranchBlock> getBranchOpt(Block block) {
        return TreeHelper.isBranch(block) ? Optional.of((BranchBlock)block) : Optional.empty();
    }

    public static Optional<BranchBlock> getBranchOpt(BlockState state) {
        Block block = state.getBlock();
        return TreeHelper.isBranch(block) ? Optional.of((BranchBlock)block) : Optional.empty();
    }

    public static Optional<BranchBlock> getBranchOpt(TreePart treePart) {
        return treePart instanceof BranchBlock ? Optional.of((BranchBlock)treePart) : Optional.empty();
    }

    public static boolean isLeaves(Block block) {
        return block instanceof DynamicLeavesBlock;
    }

    public static boolean isLeaves(BlockState state) {
        return TreeHelper.isLeaves(state.getBlock());
    }

    @Nullable
    public static DynamicLeavesBlock getLeaves(Block block) {
        return TreeHelper.isLeaves(block) ? (DynamicLeavesBlock)block : null;
    }

    @Nullable
    public static DynamicLeavesBlock getLeaves(TreePart treePart) {
        return treePart instanceof DynamicLeavesBlock ? (DynamicLeavesBlock)treePart : null;
    }

    @Nullable
    public static DynamicLeavesBlock getLeaves(BlockState state) {
        return TreeHelper.getLeaves(state.getBlock());
    }

    public static boolean isRooty(Block block) {
        return block instanceof SoilBlock;
    }

    public static boolean isRooty(BlockState state) {
        return TreeHelper.isRooty(state.getBlock());
    }

    @Nullable
    public static SoilBlock getRooty(Block block) {
        return TreeHelper.isRooty(block) ? (SoilBlock)block : null;
    }

    @Nullable
    public static SoilBlock getRooty(TreePart treePart) {
        return treePart instanceof SoilBlock ? (SoilBlock)treePart : null;
    }

    @Nullable
    public static SoilBlock getRooty(BlockState state) {
        return TreeHelper.getRooty(state.getBlock());
    }

    public static Optional<SoilBlock> getRootyOpt(BlockState state) {
        Block block = state.getBlock();
        return TreeHelper.isRooty(block) ? Optional.of((SoilBlock)block) : Optional.empty();
    }
}

