/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.nodemapper;

import com.dtteam.dynamictrees.api.network.NodeInspector;
import com.dtteam.dynamictrees.api.voxmap.SimpleVoxmap;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.species.Species;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TransformNode
implements NodeInspector {
    private final Species fromSpecies;
    private final Species toSpecies;
    private static final int TEST_LEAVES_RADIUS = 3;

    public TransformNode(Species fromTree, Species toTree) {
        this.fromSpecies = fromTree;
        this.toSpecies = toTree;
    }

    @Override
    public boolean run(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        int radius;
        BranchBlock branch = TreeHelper.getBranch(state);
        if (branch != null && this.fromSpecies.getFamily() == branch.getFamily() && (radius = branch.getRadius(state)) > 0) {
            BranchBlock newBranchBlock = this.toSpecies.getFamily().getBranch().orElse(null);
            if (this.fromSpecies.getFamily().getStrippedBranch().orElse(null) == branch) {
                newBranchBlock = this.toSpecies.getFamily().getStrippedBranch().get();
            }
            newBranchBlock.setRadius(level, pos, radius, null);
            if (radius == 1) {
                this.transformSurroundingLeaves(level, pos);
            }
        }
        return true;
    }

    @Override
    public boolean returnRun(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        return false;
    }

    public void transformSurroundingLeaves(LevelAccessor world, BlockPos twigPos) {
        if (world.isClientSide()) {
            return;
        }
        SimpleVoxmap leafCluster = this.fromSpecies.getLeavesProperties().getCellKit().getLeafCluster();
        int xBound = leafCluster.getLenX();
        int yBound = leafCluster.getLenY();
        int zBound = leafCluster.getLenZ();
        BlockPos.betweenClosedStream((BlockPos)twigPos.offset(-xBound, -yBound, -zBound), (BlockPos)twigPos.offset(xBound, yBound, zBound)).forEach(testPos -> {
            if (this.fromSpecies.getLeavesProperties().getCellKit().getLeafCluster().getVoxel(twigPos, (BlockPos)testPos) == 0) {
                return;
            }
            BlockState state = world.getBlockState(testPos);
            if (this.fromSpecies.getFamily().isCompatibleGenericLeaves(this.fromSpecies, state, world, (BlockPos)testPos)) {
                int hydro = state.getBlock() instanceof DynamicLeavesBlock ? (Integer)state.getValue((Property)DynamicLeavesBlock.DISTANCE) : 2;
                world.setBlock(testPos, this.toSpecies.getLeavesProperties().getDynamicLeavesState(hydro), 3);
            }
        });
    }
}

