/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.nodemapper;

import com.dtteam.dynamictrees.api.network.NodeInspector;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.tree.TreeHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class NetVolumeNode
implements NodeInspector {
    private final Volume volume = new Volume();

    @Override
    public boolean run(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        if (TreeHelper.isBranch(state)) {
            BranchBlock branchBlock = TreeHelper.getBranch(state);
            int radius = branchBlock.getRadius(state);
            this.volume.addVolume(radius * radius * 64, branchBlock.getFamily().getBranchBlockIndex(branchBlock));
        }
        return true;
    }

    @Override
    public boolean returnRun(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        return false;
    }

    public Volume getVolume() {
        return this.volume;
    }

    public static final class Volume {
        public static final int VOXELSPERLOG = 4096;
        private final Map<Integer, Integer> branchVolumes = new HashMap<Integer, Integer>();
        int maxBranch;

        public Volume() {
            this(0);
        }

        public Volume(int volume) {
            this.branchVolumes.put(0, volume);
            this.maxBranch = 0;
        }

        public Volume(int ... volumes) {
            for (int i = 0; i < volumes.length; ++i) {
                if (volumes[i] == 0) continue;
                this.branchVolumes.put(i, volumes[i]);
            }
            this.maxBranch = volumes.length;
        }

        public void addVolume(int volume) {
            this.addVolume(volume, 0);
        }

        public void addVolume(int volume, int branch) {
            if (this.branchVolumes.containsKey(branch)) {
                this.branchVolumes.computeIfPresent(branch, (b, v) -> v + volume);
            } else {
                this.branchVolumes.put(branch, volume);
            }
            if (branch > this.maxBranch) {
                this.maxBranch = branch;
            }
        }

        public void addVolume(Volume other) {
            for (Map.Entry<Integer, Integer> vols : other.branchVolumes.entrySet()) {
                this.addVolume(vols.getValue(), vols.getKey());
            }
        }

        public void multiplyVolume(double multiplier) {
            this.branchVolumes.replaceAll((a, b) -> (int)((double)b.intValue() * multiplier));
        }

        public int[] getRawVolumesArray() {
            int[] volumes = new int[this.maxBranch + 1];
            for (int i = 0; i <= this.maxBranch; ++i) {
                int vol = 0;
                if (this.branchVolumes.containsKey(i)) {
                    vol = this.branchVolumes.get(i);
                }
                volumes[i] = vol;
            }
            return volumes;
        }

        public float getVolume() {
            return (float)this.getRawVolume() / 4096.0f;
        }

        public float getVolume(int branch) {
            return (float)this.getRawVolume(branch) / 4096.0f;
        }

        public int getRawVolume() {
            int totalVolume = 0;
            for (int i = 0; i < this.branchVolumes.size(); ++i) {
                totalVolume += this.getRawVolume(i);
            }
            return totalVolume;
        }

        public int getRawVolume(int branch) {
            if (this.branchVolumes.containsKey(branch)) {
                return this.branchVolumes.get(branch);
            }
            return 0;
        }
    }
}

