/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.nodemapper;

import com.dtteam.dynamictrees.api.network.NodeInspector;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class FindEndsNode
implements NodeInspector {
    private final List<BlockPos> endPoints;
    private BlockPos last;

    public FindEndsNode() {
        this(new ArrayList<BlockPos>(32));
    }

    public FindEndsNode(List<BlockPos> ends) {
        this.endPoints = ends;
        this.last = BlockPos.ZERO;
    }

    @Override
    public boolean run(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        return true;
    }

    @Override
    public boolean returnRun(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        BlockPos dPos = pos.subtract((Vec3i)this.last);
        if (dPos.getX() * dPos.getX() + dPos.getY() * dPos.getY() + dPos.getZ() * dPos.getZ() != 1) {
            this.endPoints.add(pos);
        }
        this.last = pos;
        return false;
    }

    public List<BlockPos> getEnds() {
        if (this.endPoints.isEmpty()) {
            this.endPoints.add(this.last);
        }
        return this.endPoints;
    }
}

