/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.genfeature;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.api.voxmap.SimpleVoxmap;
import com.dtteam.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.utility.CoordUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class ShroomlightGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Block> SHROOMLIGHT_BLOCK = ConfigurationProperty.block("shroomlight");
    private static final Direction[] HORIZONTALS = CoordUtils.HORIZONTALS;
    private static final double VANILLA_GROW_CHANCE = (double)0.005f;

    public ShroomlightGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(SHROOMLIGHT_BLOCK, MAX_HEIGHT, CAN_GROW_PREDICATE, PLACE_CHANCE, MAX_COUNT);
    }

    @Override
    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(SHROOMLIGHT_BLOCK, Blocks.SHROOMLIGHT)).with(MAX_HEIGHT, 32)).with(CAN_GROW_PREDICATE, (level, blockPos) -> (double)level.getRandom().nextFloat() <= (double)0.005f)).with(PLACE_CHANCE, Float.valueOf(0.3f))).with(MAX_COUNT, 4);
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        boolean placed = this.placeShroomlightsInValidPlace(configuration, context.level(), context.pos(), true);
        if (placed) {
            SimpleVoxmap leafMap = context.species().getLeavesProperties().getCellKit().getLeafCluster();
            for (BlockPos endPos : context.endPoints()) {
                TreeHelper.ageVolume(context.level(), endPos.below(leafMap.getLenY() / 2 + 1), leafMap.getLenX() / 2, leafMap.getLenY() / 2 - 1, 4, true);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        return context.natural() && ((GenFeature.CanGrowPredicate)configuration.get(CAN_GROW_PREDICATE)).test(context.level(), context.pos().above()) && context.fertility() != 0 && this.placeShroomlightsInValidPlace(configuration, context.level(), context.pos(), false);
    }

    private boolean placeShroomlightsInValidPlace(GenFeatureConfiguration configuration, LevelAccessor level, BlockPos rootPos, boolean worldGen) {
        int treeHeight = this.getTreeHeight(level, rootPos, (Integer)configuration.get(MAX_HEIGHT));
        Block shroomlightBlock = configuration.get(SHROOMLIGHT_BLOCK);
        List<BlockPos> validSpaces = this.findBranchPits(configuration, level, rootPos, treeHeight);
        if (validSpaces == null) {
            return false;
        }
        if (!validSpaces.isEmpty()) {
            if (worldGen) {
                int placed = 0;
                for (BlockPos chosenSpace : validSpaces) {
                    if (!(level.getRandom().nextFloat() <= ((Float)configuration.get(PLACE_CHANCE)).floatValue())) continue;
                    level.setBlock(chosenSpace, shroomlightBlock.defaultBlockState(), 2);
                    if (++placed <= (Integer)configuration.get(MAX_COUNT)) continue;
                    break;
                }
            } else {
                BlockPos chosenSpace = validSpaces.get(level.getRandom().nextInt(validSpaces.size()));
                level.setBlock(chosenSpace, shroomlightBlock.defaultBlockState(), 2);
            }
            return true;
        }
        return false;
    }

    private int getTreeHeight(LevelAccessor level, BlockPos rootPos, int maxHeight) {
        for (int i = 1; i < maxHeight; ++i) {
            if (TreeHelper.isBranch(level.getBlockState(rootPos.above(i)))) continue;
            return i - 1;
        }
        return maxHeight;
    }

    @Nullable
    private List<BlockPos> findBranchPits(GenFeatureConfiguration configuration, LevelAccessor level, BlockPos rootPos, int maxHeight) {
        int existingBlocks = 0;
        LinkedList<BlockPos> validSpaces = new LinkedList<BlockPos>();
        boolean firstPit = true;
        block0: for (int y = 2; y < maxHeight; ++y) {
            BlockPos trunkPos = rootPos.above(y);
            for (Direction dir : HORIZONTALS) {
                BlockPos sidePos = trunkPos.relative(dir);
                if ((level.isEmptyBlock(sidePos) || level.getBlockState(sidePos).getBlock() instanceof DynamicLeavesBlock) && TreeHelper.isBranch(level.getBlockState(sidePos.above()))) {
                    if (firstPit) {
                        firstPit = false;
                        continue block0;
                    }
                    validSpaces.add(sidePos);
                    continue;
                }
                if (level.getBlockState(sidePos).getBlock() != configuration.get(SHROOMLIGHT_BLOCK) || ++existingBlocks <= (Integer)configuration.get(MAX_COUNT)) continue;
                return null;
            }
        }
        return validSpaces;
    }
}

