/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.genfeature;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.HugeMushroomGenFeature;
import com.dtteam.dynamictrees.systems.genfeature.context.FullGenerationContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.dtteam.dynamictrees.tree.ChunkTreeHelper;
import com.dtteam.dynamictrees.utility.CoordUtils;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;

public class HugeMushroomUndergrowthGenFeature
extends HugeMushroomGenFeature {
    public static final ConfigurationProperty<Integer> MAX_MUSHROOMS = ConfigurationProperty.integer("max_mushrooms");
    public static final ConfigurationProperty<Integer> MAX_ATTEMPTS = ConfigurationProperty.integer("max_attempts");

    public HugeMushroomUndergrowthGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        super.registerProperties();
        this.register(MAX_MUSHROOMS, MAX_ATTEMPTS);
    }

    @Override
    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(MAX_MUSHROOMS, 2)).with(MAX_ATTEMPTS, 4);
    }

    @Override
    protected boolean generate(GenFeatureConfiguration configuration, FullGenerationContext context) {
        return false;
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        if (context.endPoints().isEmpty() || !context.isWorldGen() || context.radius() < 5) {
            return false;
        }
        LevelAccessor level = context.level();
        BlockPos rootPos = context.pos();
        BlockPos lowest = Collections.min(context.endPoints(), Comparator.comparingInt(Vec3i::getY));
        RandomSource rand = context.random();
        int success = 0;
        for (int tries = 0; tries < configuration.get(MAX_ATTEMPTS); ++tries) {
            int height;
            int maxHeight;
            float angle = (float)((double)rand.nextFloat() * Math.PI * 2.0);
            int xOff = (int)(Mth.sin((float)angle) * (float)(context.radius() - 1));
            int zOff = (int)(Mth.cos((float)angle) * (float)(context.radius() - 1));
            BlockPos mushPos = rootPos.offset(xOff, 0, zOff);
            if (!ChunkTreeHelper.canCheckSurroundings(level, mushPos = CoordUtils.findWorldSurface(level, new BlockPos((Vec3i)mushPos), context.isWorldGen()).above(), 3) || (maxHeight = lowest.getY() - mushPos.getY()) < 2 || !this.setHeight(height = Math.min(Mth.clamp((int)(rand.nextInt(maxHeight) + 3), (int)3, (int)maxHeight), this.maxHeightBase + this.maxHeightVar - 1)).generateMushrooms(configuration, new FullGenerationContext(context.level(), mushPos.below(), context.species(), context.biome(), context.radius(), context.isWorldGen())) || ++success < configuration.get(MAX_MUSHROOMS)) continue;
            return true;
        }
        return false;
    }
}

