/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.genfeature;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.api.voxmap.SimpleVoxmap;
import com.dtteam.dynamictrees.api.worldgen.BiomePredicate;
import com.dtteam.dynamictrees.systems.cell.LeafClusters;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.context.FullGenerationContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.utility.CoordUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BushGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Block> LOG = ConfigurationProperty.block("log");
    public static final ConfigurationProperty<Block> LEAVES = ConfigurationProperty.block("leaves");
    public static final ConfigurationProperty<Block> SECONDARY_LEAVES = ConfigurationProperty.block("secondary_leaves");
    public static final ConfigurationProperty<Integer> SECONDARY_LEAVES_CHANCE = ConfigurationProperty.integer("secondary_leaves_chance");

    public BushGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(BIOME_PREDICATE, LOG, LEAVES, SECONDARY_LEAVES, SECONDARY_LEAVES_CHANCE);
    }

    @Override
    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(BIOME_PREDICATE, i -> true)).with(LOG, Blocks.OAK_LOG)).with(LEAVES, Blocks.OAK_LEAVES)).with(SECONDARY_LEAVES, null)).with(SECONDARY_LEAVES_CHANCE, 4);
    }

    @Override
    protected boolean generate(GenFeatureConfiguration configuration, FullGenerationContext context) {
        this.commonGen(configuration, context.level(), context.pos(), context.species(), context.random(), context.radius(), context.isWorldGen());
        return true;
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        if (((BiomePredicate)configuration.get(BIOME_PREDICATE)).test(context.biome())) {
            this.commonGen(configuration, context.level(), context.pos(), context.species(), context.random(), context.radius(), context.isWorldGen());
            return true;
        }
        return false;
    }

    protected void commonGen(GenFeatureConfiguration configuration, LevelAccessor level, BlockPos rootPos, Species species, RandomSource random, int radius, boolean worldGen) {
        if (radius <= 2) {
            return;
        }
        Vec3 vTree = new Vec3((double)rootPos.getX(), (double)rootPos.getY(), (double)rootPos.getZ()).add(0.5, 0.5, 0.5);
        for (int i = 0; i < 2; ++i) {
            int rad = Mth.clamp((int)(random.nextInt(radius - 2) + 2), (int)2, (int)(radius - 1));
            Vec3 v = vTree.add(new Vec3(1.0, 0.0, 0.0).scale((double)rad).yRot((float)((double)random.nextFloat() * Math.PI * 2.0)));
            BlockPos vPos = BlockPos.containing((Position)v);
            BlockPos groundPos = CoordUtils.findWorldSurface(level, vPos, worldGen);
            BlockState soilBlockState = level.getBlockState(groundPos);
            BlockPos pos = groundPos.above();
            if (level.getBlockState(groundPos).liquid() || !species.isAcceptableSoil((LevelReader)level, groundPos, soilBlockState)) continue;
            level.setBlock(pos, configuration.get(LOG).defaultBlockState(), 3);
            SimpleVoxmap leafMap = LeafClusters.BUSH;
            BlockPos.MutableBlockPos leafPos = new BlockPos.MutableBlockPos();
            for (BlockPos.MutableBlockPos dPos : leafMap.getAllNonZero()) {
                leafPos.set(pos.getX() + dPos.getX(), pos.getY() + dPos.getY(), pos.getZ() + dPos.getZ());
                if (BushGenFeature.coordHashCode((BlockPos)leafPos) % 5 == 0 || !level.getBlockState((BlockPos)leafPos).canBeReplaced()) continue;
                this.placeLeaves(configuration, level, random, (BlockPos)leafPos);
            }
        }
    }

    private void placeLeaves(GenFeatureConfiguration configuration, LevelAccessor level, RandomSource random, BlockPos leafPos) {
        Block leavesBlock = this.selectLeavesBlock(random, configuration.get(SECONDARY_LEAVES_CHANCE), configuration.get(LEAVES), configuration.getAsOptional(SECONDARY_LEAVES).orElse(null));
        this.placeLeavesBlock(level, leafPos, leavesBlock);
    }

    private Block selectLeavesBlock(RandomSource random, int secondaryLeavesChance, Block leavesBlock, @Nullable Block secondaryLeavesBlock) {
        return secondaryLeavesBlock == null || random.nextInt(secondaryLeavesChance) != 0 ? leavesBlock : secondaryLeavesBlock;
    }

    private void placeLeavesBlock(LevelAccessor level, BlockPos leafPos, Block leavesBlock) {
        BlockState leafState = leavesBlock.defaultBlockState();
        if (leavesBlock instanceof LeavesBlock) {
            leafState = (BlockState)leafState.setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true));
        }
        level.setBlock(leafPos, leafState, 3);
    }

    public static int coordHashCode(BlockPos pos) {
        int hash = (pos.getX() * 4111 ^ pos.getY() * 271 ^ pos.getZ() * 3067) >> 1;
        return hash & 0xFFFF;
    }
}

