/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.genfeature;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.api.worldgen.BiomePredicate;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.context.FullGenerationContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PostRotContext;
import net.minecraft.resources.ResourceLocation;

public class BiomePredicateGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Boolean> ONLY_WORLD_GEN = ConfigurationProperty.bool("only_world_gen");
    public static final ConfigurationProperty<GenFeatureConfiguration> GEN_FEATURE = ConfigurationProperty.property("gen_feature", GenFeatureConfiguration.class);

    public BiomePredicateGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(BIOME_PREDICATE, GEN_FEATURE, ONLY_WORLD_GEN);
    }

    @Override
    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(BIOME_PREDICATE, i -> true)).with(GEN_FEATURE, GenFeatureConfiguration.getNull())).with(ONLY_WORLD_GEN, false);
    }

    @Override
    protected boolean generate(GenFeatureConfiguration configuration, FullGenerationContext context) {
        boolean worldGen = context.isWorldGen();
        GenFeatureConfiguration configurationToPlace = configuration.get(GEN_FEATURE);
        if (configuration.getGenFeature().getRegistryName().equals((Object)DynamicTrees.NULL)) {
            return false;
        }
        if ((!configuration.get(ONLY_WORLD_GEN).booleanValue() || worldGen) && ((BiomePredicate)configuration.get(BIOME_PREDICATE)).test(context.biome())) {
            return configurationToPlace.generate(GenFeature.Type.FULL, context);
        }
        return false;
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        boolean worldGen = context.isWorldGen();
        GenFeatureConfiguration configurationToPlace = configuration.get(GEN_FEATURE);
        if (configuration.getGenFeature().getRegistryName().equals((Object)DynamicTrees.NULL)) {
            return false;
        }
        if ((!configuration.get(ONLY_WORLD_GEN).booleanValue() || worldGen) && ((BiomePredicate)configuration.get(BIOME_PREDICATE)).test(context.biome())) {
            return configurationToPlace.generate(GenFeature.Type.POST_GENERATION, context);
        }
        return false;
    }

    @Override
    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        GenFeatureConfiguration configurationToPlace = configuration.get(GEN_FEATURE);
        if (configuration.getGenFeature().getRegistryName().equals((Object)DynamicTrees.NULL)) {
            return false;
        }
        if (!configuration.get(ONLY_WORLD_GEN).booleanValue() && ((BiomePredicate)configuration.get(BIOME_PREDICATE)).test(context.level().getBiome(context.pos()))) {
            return configurationToPlace.generate(GenFeature.Type.POST_GROW, context);
        }
        return false;
    }

    @Override
    protected boolean postRot(GenFeatureConfiguration configuration, PostRotContext context) {
        GenFeatureConfiguration configurationToPlace = configuration.get(GEN_FEATURE);
        if (configuration.getGenFeature().getRegistryName().equals((Object)DynamicTrees.NULL)) {
            return false;
        }
        if (!configuration.get(ONLY_WORLD_GEN).booleanValue() && ((BiomePredicate)configuration.get(BIOME_PREDICATE)).test(context.level().getBiome(context.pos()))) {
            return configurationToPlace.generate(GenFeature.Type.POST_ROT, context);
        }
        return false;
    }
}

