/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems;

import com.dtteam.dynamictrees.api.function.TetraFunction;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BranchConnectables {
    private static final Map<Block, TetraFunction<BlockState, BlockGetter, BlockPos, Direction, Integer>> connectablesMap = new HashMap<Block, TetraFunction<BlockState, BlockGetter, BlockPos, Direction, Integer>>();

    public static void makeBlockConnectable(Block block, TetraFunction<BlockState, BlockGetter, BlockPos, Direction, Integer> radiusFunction) {
        connectablesMap.putIfAbsent(block, radiusFunction);
    }

    public static boolean isBlockConnectable(Block block) {
        return connectablesMap.containsKey(block);
    }

    public static int getConnectionRadiusForBlock(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        Block block = state.getBlock();
        return BranchConnectables.isBlockConnectable(block) ? connectablesMap.get(block).apply(state, world, pos, side) : 0;
    }
}

