/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.registry;

import com.dtteam.dynamictrees.api.network.BranchDestructionData;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.soil.SoilBlock;
import com.dtteam.dynamictrees.entity.FallingTreeEntity;
import com.dtteam.dynamictrees.model.FallingTreeEntityModel;
import com.dtteam.dynamictrees.model.QuadManipulator;
import com.dtteam.dynamictrees.model.modeldata.ModelConnections;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.species.Species;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.apache.commons.lang3.tuple.Pair;

public class FallingTreeEntityModelNF
extends FallingTreeEntityModel {
    public FallingTreeEntityModelNF(FallingTreeEntity entity) {
        super(entity);
    }

    @Override
    public List<FallingTreeEntityModel.TreeQuadData> generateTreeQuads(FallingTreeEntity entity) {
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        BranchDestructionData destructionData = entity.getDestroyData();
        Direction cutDir = destructionData.cutDir;
        ArrayList<FallingTreeEntityModel.TreeQuadData> treeQuads = new ArrayList<FallingTreeEntityModel.TreeQuadData>();
        int[] connectionArray = new int[6];
        if (destructionData.getNumBranches() > 0) {
            BlockState exState = destructionData.getBranchBlockState(0);
            BlockPos cutPos = destructionData.cutPos;
            if (exState != null) {
                SoilBlock soilBlock;
                Species species = destructionData.species;
                BlockPos rootPos = cutPos.below();
                BlockState bottomState = entity.level().getBlockState(rootPos);
                boolean rootyBlockAdded = false;
                if (TreeHelper.isRooty(bottomState) && (soilBlock = TreeHelper.getRooty(bottomState)) != null && soilBlock.fallWithTree(bottomState, entity.level(), rootPos, !destructionData.getRelativeCutPos().equals((Object)BlockPos.ZERO))) {
                    BakedModel rootyModel = dispatcher.getBlockModel(bottomState);
                    BlockPos cutOffset = destructionData.getRelativeCutPos();
                    treeQuads.addAll(FallingTreeEntityModelNF.toTreeQuadData(QuadManipulator.getQuads(rootyModel, bottomState, new Vec3((double)cutOffset.getX(), (double)(cutOffset.getY() - 1), (double)cutOffset.getZ()), entity.getRandom(), ModelData.EMPTY), destructionData.species.getFamily().getRootColor(bottomState, soilBlock.getColorFromBark()), bottomState));
                    rootyBlockAdded = true;
                }
                BakedModel branchModel = dispatcher.getBlockModel(exState);
                destructionData.getConnections(0, connectionArray);
                boolean bottomRingsAdded = false;
                if (!rootyBlockAdded && connectionArray[cutDir.get3DDataValue()] > 0) {
                    BlockPos offsetPos = destructionData.getRelativeCutPos().relative(cutDir);
                    float offset = (float)(8 - Math.min(((BranchBlock)exState.getBlock()).getRadius(exState), 8)) / 16.0f;
                    treeQuads.addAll(FallingTreeEntityModelNF.toTreeQuadData(QuadManipulator.getQuads(branchModel, exState, new Vec3((double)offsetPos.getX(), (double)offsetPos.getY(), (double)offsetPos.getZ()).scale((double)offset), new Direction[]{null}, entity.getRandom(), new ModelConnections(cutDir).setFamily(TreeHelper.getBranch(exState)).toModelData()), exState));
                    bottomRingsAdded = true;
                }
                for (int index = 0; index < destructionData.getNumBranches(); ++index) {
                    Block previousBranch = exState.getBlock();
                    if (!previousBranch.equals((exState = destructionData.getBranchBlockState(index)).getBlock())) {
                        branchModel = dispatcher.getBlockModel(exState);
                    }
                    BlockPos relPos = destructionData.getBranchRelPos(index);
                    destructionData.getConnections(index, connectionArray);
                    ModelConnections modelConnections = new ModelConnections(connectionArray).setFamily(TreeHelper.getBranch(exState));
                    if (index == 0 && bottomRingsAdded) {
                        modelConnections.setForceRing(cutDir);
                    }
                    treeQuads.addAll(FallingTreeEntityModelNF.toTreeQuadData(QuadManipulator.getQuads(branchModel, exState, new Vec3((double)relPos.getX(), (double)relPos.getY(), (double)relPos.getZ()), entity.getRandom(), modelConnections.toModelData()), exState));
                }
                for (Pair<BlockPos, BlockState> leafLoc : destructionData.getAllLeavesWithPos()) {
                    BlockState leafState = (BlockState)leafLoc.getValue();
                    List<BakedQuad> bakedQuads = QuadManipulator.getQuads(dispatcher.getBlockModel(leafState), leafState, new Vec3((double)((BlockPos)leafLoc.getKey()).getX(), (double)((BlockPos)leafLoc.getKey()).getY(), (double)((BlockPos)leafLoc.getKey()).getZ()), entity.getRandom(), ModelData.EMPTY);
                    treeQuads.addAll(FallingTreeEntityModelNF.toTreeQuadData(bakedQuads, species.leafColorMultiplier(entity.level(), cutPos.offset((Vec3i)leafLoc.getKey())), leafState));
                }
            }
        }
        return treeQuads;
    }
}

