/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.platform;

import com.dtteam.dynamictrees.api.registry.AbstractRegistry;
import com.dtteam.dynamictrees.api.registry.RegistryEntry;
import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.api.resource.TreeResourceManager;
import com.dtteam.dynamictrees.api.resource.loading.StagedApplierResourceLoader;
import com.dtteam.dynamictrees.api.worldgen.PoissonDiscProvider;
import com.dtteam.dynamictrees.deserialization.JsonPropertyAppliers;
import com.dtteam.dynamictrees.deserialization.PropertyAppliers;
import com.dtteam.dynamictrees.event.AddResourceLoadersEvent;
import com.dtteam.dynamictrees.event.ApplierRegistryEvent;
import com.dtteam.dynamictrees.event.BiomeEntryApplierRegistryEvent;
import com.dtteam.dynamictrees.event.BiomeSuitabilityEvent;
import com.dtteam.dynamictrees.event.CancellationApplierRegistryEvent;
import com.dtteam.dynamictrees.event.JsonDeserializerRegistryEvent;
import com.dtteam.dynamictrees.event.PoissonDiscProviderCreateEvent;
import com.dtteam.dynamictrees.event.RegistryEvent;
import com.dtteam.dynamictrees.event.SeedVoluntaryPlantEvent;
import com.dtteam.dynamictrees.event.SpeciesPostGenerationEvent;
import com.dtteam.dynamictrees.event.TransitionSaplingToTreeEvent;
import com.dtteam.dynamictrees.event.TypeRegistryEvent;
import com.dtteam.dynamictrees.item.Seed;
import com.dtteam.dynamictrees.platform.services.IEventHelper;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.dtteam.dynamictrees.tree.species.Species;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.NeoForge;

public class NeoForgeEventHelper
implements IEventHelper {
    @Override
    public <V extends RegistryEntry<V>> void postRegistryEvent(AbstractRegistry<V> registry) {
        ModLoader.postEvent(new RegistryEvent<V>(registry));
    }

    @Override
    public <V extends RegistryEntry<V>> void postTypedRegistryEvent(TypedRegistry<V> registry) {
        ModLoader.postEvent(new TypeRegistryEvent<V>(registry));
    }

    @Override
    public void postAddResourceLoadersEventPre(TreeResourceManager resourceManager) {
        ModLoader.postEvent((Event)new AddResourceLoadersEvent.Pre(resourceManager));
    }

    @Override
    public void postAddResourceLoadersEventPost(TreeResourceManager resourceManager) {
        ModLoader.postEvent((Event)new AddResourceLoadersEvent.Post(resourceManager));
    }

    @Override
    public void postJsonDeserializerRegistryEvent() {
        ModLoader.postEvent((Event)new JsonDeserializerRegistryEvent());
    }

    @Override
    public <O, I> void postApplierEvent(StagedApplierResourceLoader.ApplierStage stage, PropertyAppliers<O, I> appliers, String identifier) {
        switch (stage) {
            case LOAD: {
                ModLoader.postEvent(new ApplierRegistryEvent.Load<O, I>(appliers, identifier));
                break;
            }
            case GATHER_DATA: {
                ModLoader.postEvent(new ApplierRegistryEvent.GatherData<O, I>(appliers, identifier));
                break;
            }
            case SETUP: {
                ModLoader.postEvent(new ApplierRegistryEvent.Setup<O, I>(appliers, identifier));
                break;
            }
            case RELOAD: {
                ModLoader.postEvent(new ApplierRegistryEvent.Reload<O, I>(appliers, identifier));
                break;
            }
            case COMMON: {
                ModLoader.postEvent(new ApplierRegistryEvent.Common<O, I>(appliers, identifier));
            }
        }
    }

    @Override
    public <O> void postBiomeEntryApplierEvent(JsonPropertyAppliers<O> appliers, String identifier) {
        ModLoader.postEvent(new BiomeEntryApplierRegistryEvent<O>(appliers, identifier));
    }

    @Override
    public <O> void postCancellationApplierEvent(JsonPropertyAppliers<O> appliers, String identifier) {
        ModLoader.postEvent(new CancellationApplierRegistryEvent<O>(appliers, identifier));
    }

    @Override
    public void postSpeciesPostGenerationEvent(PostGenerationContext context) {
        NeoForge.EVENT_BUS.post((Event)new SpeciesPostGenerationEvent(context.level(), context.species(), context.pos(), context.endPoints(), context.initialDirtState()));
    }

    @Override
    public boolean postTransitionSaplingToTreeEvent(Species species, Level level, BlockPos pos) {
        return ((TransitionSaplingToTreeEvent)NeoForge.EVENT_BUS.post((Event)new TransitionSaplingToTreeEvent(species, level, pos))).isCanceled();
    }

    @Override
    public boolean canCropGrow(Level level, BlockPos pos, BlockState state, boolean doGrow) {
        return CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (boolean)doGrow);
    }

    @Override
    public void cropGrowPost(Level level, BlockPos pos, BlockState state) {
        CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
    }

    @Override
    public Species.BiomeSuitabilityEventResult postBiomeSuitabilityEvent(Level level, Biome biome, Species species, BlockPos pos) {
        BiomeSuitabilityEvent suitabilityEvent = new BiomeSuitabilityEvent(level, biome, species, pos);
        NeoForge.EVENT_BUS.post((Event)suitabilityEvent);
        return new Species.BiomeSuitabilityEventResult(suitabilityEvent.isHandled(), suitabilityEvent.getSuitability());
    }

    @Override
    public Seed.VoluntaryPlantEventResult postSeedVoluntaryPlantEvent(ItemEntity entityItem, Species species, BlockPos pos, boolean willPlant) {
        SeedVoluntaryPlantEvent event = (SeedVoluntaryPlantEvent)NeoForge.EVENT_BUS.post((Event)new SeedVoluntaryPlantEvent(entityItem, species, pos, willPlant));
        return new Seed.VoluntaryPlantEventResult(event.isCanceled(), event.getWillPlant());
    }

    @Override
    public PoissonDiscProvider postPoissonDiscProviderCreateEvent(LevelAccessor level, PoissonDiscProvider poissonDiscProvider) {
        PoissonDiscProviderCreateEvent poissonDiscProviderCreateEvent = new PoissonDiscProviderCreateEvent(level, poissonDiscProvider);
        NeoForge.EVENT_BUS.post((Event)poissonDiscProviderCreateEvent);
        return poissonDiscProviderCreateEvent.getPoissonDiscProvider();
    }
}

