/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.model;

import com.dtteam.dynamictrees.api.network.BranchDestructionData;
import com.dtteam.dynamictrees.entity.FallingTreeEntity;
import com.dtteam.dynamictrees.tree.species.Species;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class FallingTreeEntityModel
extends EntityModel<FallingTreeEntity> {
    protected final List<TreeQuadData> quads;
    protected final int entityId;
    protected final Species species;

    public FallingTreeEntityModel(FallingTreeEntity entity) {
        BranchDestructionData destructionData = entity.getDestroyData();
        Species species = destructionData.species;
        this.quads = this.generateTreeQuads(entity);
        this.species = species;
        this.entityId = entity.getId();
    }

    public List<TreeQuadData> getQuads() {
        return this.quads;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public static int getBrightness(FallingTreeEntity entity) {
        BranchDestructionData destructionData = entity.getDestroyData();
        Level world = entity.level();
        return world.getBlockState(destructionData.cutPos).getLightEmission();
    }

    public List<TreeQuadData> generateTreeQuads(FallingTreeEntity entity) {
        return List.of();
    }

    public void setupAnim(FallingTreeEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        for (TreeQuadData treeQuad : this.getQuads()) {
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            BakedQuad bakedQuad = treeQuad.bakedQuad;
            if (bakedQuad.isTinted()) {
                color = this.species == null ? treeQuad.color : this.species.colorTreeQuads(treeQuad.color, treeQuad);
                r = (float)(color >> 16 & 0xFF) / 255.0f;
                g = (float)(color >> 8 & 0xFF) / 255.0f;
                b = (float)(color & 0xFF) / 255.0f;
            }
            if (bakedQuad.isShade()) {
                float diffuse = 0.8f;
                r *= diffuse;
                g *= diffuse;
                b *= diffuse;
            }
            buffer.putBulkData(poseStack.last(), bakedQuad, r, g, b, 1.0f, packedLight, packedOverlay);
        }
    }

    public static List<TreeQuadData> toTreeQuadData(List<BakedQuad> bakedQuads, BlockState state) {
        return FallingTreeEntityModel.toTreeQuadData(bakedQuads, 0xFFFFFF, state);
    }

    public static List<TreeQuadData> toTreeQuadData(List<BakedQuad> bakedQuads, int defaultColor, BlockState state) {
        return bakedQuads.stream().map(bakedQuad -> new TreeQuadData((BakedQuad)bakedQuad, defaultColor, state)).collect(Collectors.toList());
    }

    public record TreeQuadData(BakedQuad bakedQuad, int color, BlockState state) {
    }
}

