/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.mixin;

import com.dtteam.dynamictrees.block.branch.BasicRootsBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BushBlock.class})
public class MixinBushBlock {
    @Shadow
    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    @Inject(at={@At(value="HEAD")}, cancellable=true, method={"canSurvive (Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z"})
    private void canSurvive(BlockState state, LevelReader level, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        BlockPos blockpos = pos.below();
        BlockState belowBlockState = level.getBlockState(blockpos);
        Block block = belowBlockState.getBlock();
        if (block instanceof BasicRootsBlock) {
            BasicRootsBlock roots = (BasicRootsBlock)block;
            if (belowBlockState.getValue(BasicRootsBlock.LAYER) == BasicRootsBlock.Layer.COVERED) {
                Block block2 = BasicRootsBlock.Layer.COVERED.getPrimitive(roots.getFamily()).orElse(null);
                if (block2 == null) {
                    return;
                }
                cir.setReturnValue((Object)this.mayPlaceOn(block2.defaultBlockState(), (BlockGetter)level, blockpos));
            }
        }
    }
}

