/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.item;

import com.dtteam.dynamictrees.api.substance.Emptiable;
import com.dtteam.dynamictrees.api.substance.SubstanceEffect;
import com.dtteam.dynamictrees.api.substance.SubstanceEffectProvider;
import com.dtteam.dynamictrees.registry.DTRegistries;
import com.dtteam.dynamictrees.systems.substance.DepleteSubstance;
import com.dtteam.dynamictrees.systems.substance.GrowthSubstance;
import com.dtteam.dynamictrees.systems.substance.HarvestSubstance;
import com.dtteam.dynamictrees.systems.substance.MegaSubstance;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class DendroPotion
extends Item
implements SubstanceEffectProvider,
Emptiable {
    public DendroPotion() {
        super(new Item.Properties().stacksTo(1));
    }

    public static ItemStack applyIndexTag(ItemStack potionStack, int potionIndex) {
        potionStack.set(DTRegistries.DENDRO_POTION_INDEX_DATA_COMPONENT.get(), (Object)potionIndex);
        return potionStack;
    }

    public static DendroPotionType getPotionType(ItemStack stack) {
        int index = (Integer)stack.getOrDefault(DTRegistries.DENDRO_POTION_INDEX_DATA_COMPONENT.get(), (Object)0);
        return DendroPotionType.values()[Math.clamp((long)index, 0, DendroPotionType.values().length - 1)];
    }

    @Override
    @Nullable
    public SubstanceEffect getSubstanceEffect(ItemStack itemStack) {
        return switch (DendroPotion.getPotionType(itemStack).ordinal()) {
            case 3 -> new GrowthSubstance();
            case 2 -> new MegaSubstance();
            case 1 -> new DepleteSubstance().setAmount(15);
            case 4 -> new HarvestSubstance();
            default -> null;
        };
    }

    public String getDescriptionId(ItemStack stack) {
        return this.getDescriptionId() + "." + DendroPotion.getPotionType(stack).getName();
    }

    public int getColor(ItemStack stack, int tint) {
        return tint == 0 ? DendroPotion.getPotionType(stack).getColor() : -1;
    }

    @Override
    public ItemStack getEmptyContainer() {
        return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
    }

    public static enum DendroPotionType {
        BIOCHAR(0, true, "biochar", -14212324, Items.CHARCOAL),
        DEPLETION(1, true, "depletion", -8995219, Items.SLIME_BALL),
        MEGA(2, true, "mega", -1863651, Items.BROWN_MUSHROOM),
        BURGEONING(3, true, "burgeoning", -5652802, Items.BONE_BLOCK),
        HARVEST(4, false, "harvest", -1588892, Items.GLISTERING_MELON_SLICE);

        private final int index;
        private final boolean active;
        private final String name;
        private final int color;
        private final ItemStack ingredient;
        private final int baseIndex;

        private DendroPotionType(int index, boolean active, String name, int color, Item ingredient) {
            this(index, active, name, color, ingredient, 0);
        }

        private DendroPotionType(int index, boolean active, String name, int color, Item ingredient, int baseIndex) {
            this.index = index;
            this.active = active;
            this.name = name;
            this.color = color;
            this.ingredient = new ItemStack((ItemLike)ingredient);
            this.baseIndex = baseIndex;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isActive() {
            return this.active;
        }

        public String getName() {
            return this.name;
        }

        public int getColor() {
            return this.color;
        }

        public ItemStack getIngredient() {
            return this.ingredient;
        }

        public Component getDescription() {
            return Component.translatable((String)("potion." + this.name + ".description")).withStyle(style -> style.withColor(ChatFormatting.GRAY));
        }

        public DendroPotionType getBasePotionType() {
            return DendroPotionType.values()[this.baseIndex];
        }
    }
}

