/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.deserialization.deserializer;

import com.dtteam.dynamictrees.deserialization.JsonDeserializers;
import com.dtteam.dynamictrees.deserialization.deserializer.JsonDeserializer;
import com.dtteam.dynamictrees.deserialization.result.Result;
import com.google.gson.JsonElement;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import org.jetbrains.annotations.Nullable;

public final class BuiltInRegistryEntryDeserializer<T>
implements JsonDeserializer<T> {
    private final Registry<T> registry;
    private final String registryDisplayName;
    @Nullable
    private final T nullValue;
    private final Predicate<T> validator;

    public BuiltInRegistryEntryDeserializer(Registry<T> registry, String registryDisplayName) {
        this(registry, registryDisplayName, null);
    }

    public BuiltInRegistryEntryDeserializer(Registry<T> registry, String registryDisplayName, @Nullable T nullValue) {
        this.registry = registry;
        this.registryDisplayName = registryDisplayName;
        this.nullValue = nullValue;
        this.validator = value -> value != nullValue;
    }

    @Override
    public Result<T, JsonElement> deserialize(JsonElement jsonElement) {
        AtomicBoolean intentionallyNull = new AtomicBoolean();
        return JsonDeserializers.RESOURCE_LOCATION.deserialize(jsonElement).map(registryName -> {
            if (this.nullValue != null && Objects.equals(registryName, this.registry.getKey(this.nullValue))) {
                intentionallyNull.set(true);
                return this.nullValue;
            }
            return this.registry.get(registryName);
        }, value -> intentionallyNull.get() || this.validator.test(value), "Could not find " + this.registryDisplayName + " for registry name '{}'.");
    }
}

