/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.data.generator;

import com.dtteam.dynamictrees.data.DTDataProvider;
import com.dtteam.dynamictrees.data.Generator;
import com.dtteam.dynamictrees.data.provider.DTLangProvider;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.family.UndergroundRootsFamily;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.StringUtils;

public class FamilyLangGenerator
implements Generator<DTDataProvider.Language, Family> {
    DTLangProvider provider;

    @Override
    public void generate(DTDataProvider.Language prov, Family input, Generator.Dependencies dependencies) {
        if (prov instanceof DTLangProvider) {
            DTLangProvider provider1;
            this.provider = provider1 = (DTLangProvider)prov;
            input.getBranch().ifPresent(branch -> this.treeLang((Block)branch, input, input.getLangOverride("branch")));
            if (input instanceof UndergroundRootsFamily) {
                UndergroundRootsFamily mgf = (UndergroundRootsFamily)input;
                mgf.getRoots().ifPresent(root -> this.treeLang((Block)root, input, input.getLangOverride("roots")));
            }
        }
    }

    @Override
    public Generator.Dependencies gatherDependencies(Family input) {
        return new Generator.Dependencies();
    }

    protected void treeLang(Block entry, Family family, Optional<String> blah) {
        this.provider.addBlock(() -> entry, blah.orElse(this.checkReplace(family.getRegistryName().getPath() + "_tree")));
    }

    protected void blockLang(Block entry, Optional<String> blah) {
        this.provider.addBlock(() -> entry, blah.orElse(this.checkReplace(BuiltInRegistries.BLOCK.getKey((Object)entry).getPath())));
    }

    protected String checkReplace(String path) {
        return Arrays.stream(path.split("_")).map(StringUtils::capitalize).filter(s -> !s.isBlank()).collect(Collectors.joining(" ")).trim();
    }
}

