/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.data.builder;

import com.dtteam.dynamictrees.event.handler.ClientModEventHandler;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.CustomLoaderBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public final class BranchLoaderBuilder
extends CustomLoaderBuilder<BlockModelBuilder> {
    public static final HashMap<ResourceLocation, BiFunction<BlockModelBuilder, ExistingFileHelper, BranchLoaderBuilder>> branchBuilders = new HashMap();
    private final Map<String, String> textures = new LinkedHashMap<String, String>();

    public BranchLoaderBuilder(ResourceLocation loaderId, BlockModelBuilder parent, ExistingFileHelper fileHelper) {
        super(loaderId, (ModelBuilder)parent, fileHelper, false);
    }

    public BranchLoaderBuilder texture(String key, ResourceLocation location) {
        this.textures.put(key, location.toString());
        return this;
    }

    public JsonObject toJson(JsonObject json) {
        json = super.toJson(json);
        JsonObject textures = new JsonObject();
        this.textures.forEach((key, location) -> textures.add(key, (JsonElement)new JsonPrimitive(location)));
        json.add("textures", (JsonElement)textures);
        return json;
    }

    static {
        branchBuilders.put(ClientModEventHandler.BRANCH, (parent, fileHelper) -> new BranchLoaderBuilder(ClientModEventHandler.BRANCH, (BlockModelBuilder)parent, (ExistingFileHelper)fileHelper));
        branchBuilders.put(ClientModEventHandler.SURFACE_ROOT, (parent, fileHelper) -> new BranchLoaderBuilder(ClientModEventHandler.SURFACE_ROOT, (BlockModelBuilder)parent, (ExistingFileHelper)fileHelper));
        branchBuilders.put(ClientModEventHandler.ROOTS, (parent, fileHelper) -> new BranchLoaderBuilder(ClientModEventHandler.ROOTS, (BlockModelBuilder)parent, (ExistingFileHelper)fileHelper));
    }
}

