/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.compat.waila;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.block.DynamicBlockProperties;
import com.dtteam.dynamictrees.block.fruit.FruitBlock;
import java.util.Arrays;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class WailaFruitHandler
implements IBlockComponentProvider {
    public static final ResourceLocation FRUIT_UID = DynamicTrees.location("fruit");

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        Block block = accessor.getBlock();
        if (block instanceof FruitBlock) {
            FruitBlock fruitBlock = (FruitBlock)block;
            if (Arrays.stream(DynamicBlockProperties.defaultAges).anyMatch(a -> fruitBlock.getMaxAge() == a)) {
                return;
            }
            float ageAsPercentage = fruitBlock.getAgeAsPercentage(accessor.getBlockState());
            tooltip.add((Component)Component.translatable((String)"tooltip.jade.crop_growth", (Object[])new Object[]{ageAsPercentage < 100.0f ? String.format("%.0f%%", Float.valueOf(ageAsPercentage)) : Component.translatable((String)"tooltip.jade.crop_mature").withStyle(ChatFormatting.GREEN)}));
        }
    }

    public ResourceLocation getUid() {
        return FRUIT_UID;
    }
}

