/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.compat;

import com.dtteam.dynamictrees.systems.season.ActiveSeasonGrowthCalculator;
import com.dtteam.dynamictrees.systems.season.NormalSeasonManager;
import com.dtteam.dynamictrees.systems.season.NullSeasonGrowthCalculator;
import com.dtteam.dynamictrees.systems.season.NullSeasonProvider;
import com.dtteam.dynamictrees.systems.season.SeasonCompatibilityHandler;
import com.dtteam.dynamictrees.systems.season.SeasonProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModConfig;

public class SereneSeasonsSeasonProvider
implements SeasonProvider {
    private float seasonValue = 1.0f;

    @Override
    public Float getSeasonValue(Level level, BlockPos pos) {
        return Float.valueOf(this.seasonValue);
    }

    @Override
    public void updateTick(Level level, long dayTime) {
        this.seasonValue = ((float)SeasonHelper.getSeasonState((Level)level).getSubSeason().ordinal() + 0.5f) / (float)Season.SubSeason.VALUES.length * 4.0f;
    }

    @Override
    public boolean shouldSnowMelt(Level level, BlockPos pos) {
        if (ModConfig.seasons.generateSnowAndIce && this.seasonValue < 3.0f) {
            return ((Biome)level.getBiome(pos).value()).warmEnoughToRain(pos);
        }
        return false;
    }

    public static void registerSereneSeasonsProvider() {
        SeasonCompatibilityHandler.registerSeasonManager("sereneseasons", () -> {
            NormalSeasonManager seasonManager = new NormalSeasonManager(world -> ModConfig.seasons.isDimensionWhitelisted(world.dimension()) ? new Tuple((Object)new SereneSeasonsSeasonProvider(), (Object)new ActiveSeasonGrowthCalculator()) : new Tuple((Object)new NullSeasonProvider(), (Object)new NullSeasonGrowthCalculator()));
            seasonManager.setTropicalPredicate((world, pos) -> SeasonHelper.usesTropicalSeasons((Holder)world.getBiome(pos)));
            return seasonManager;
        });
    }
}

