/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.command.subcommand;

import com.dtteam.dynamictrees.command.CommandHelper;
import com.dtteam.dynamictrees.command.subcommand.SubCommand;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;

public final class GrowPulseCommand
extends SubCommand {
    private static final String NUMBER = "number";
    private static final Collection<String> NUMBER_SUGGESTIONS = Stream.of(1, 4, 8, 16, 32, 64).map(String::valueOf).collect(Collectors.toList());

    @Override
    protected String getName() {
        return "growpulse";
    }

    @Override
    protected int getPermissionLevel() {
        return 2;
    }

    @Override
    public ArgumentBuilder<CommandSourceStack, ?> registerArgument() {
        return ((RequiredArgumentBuilder)GrowPulseCommand.blockPosArgument().executes(context -> GrowPulseCommand.executesSuccess(() -> this.sendGrowPulse((CommandSourceStack)context.getSource(), GrowPulseCommand.rootPosArgument((CommandContext<CommandSourceStack>)context), 1)))).then(Commands.argument((String)NUMBER, (ArgumentType)IntegerArgumentType.integer((int)1)).suggests((context, builder) -> SharedSuggestionProvider.suggest(NUMBER_SUGGESTIONS, (SuggestionsBuilder)builder)).executes(context -> GrowPulseCommand.executesSuccess(() -> this.sendGrowPulse((CommandSourceStack)context.getSource(), GrowPulseCommand.rootPosArgument((CommandContext<CommandSourceStack>)context), GrowPulseCommand.intArgument((CommandContext<CommandSourceStack>)context, NUMBER)))));
    }

    private void sendGrowPulse(CommandSourceStack source, BlockPos rootPos, int number) {
        for (int i = 0; i < number; ++i) {
            TreeHelper.growPulse((Level)source.getLevel(), rootPos);
        }
        GrowPulseCommand.sendSuccessAndLog(source, (Component)Component.translatable((String)"commands.dynamictrees.success.grow_pulse", (Object[])new Object[]{CommandHelper.colour(String.valueOf(number), ChatFormatting.AQUA), CommandHelper.posComponent((Vec3i)rootPos, ChatFormatting.AQUA)}));
    }
}

