/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.block.sapling;

import com.dtteam.dynamictrees.registry.DTRegistries;
import com.dtteam.dynamictrees.tree.species.Species;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class PottedSaplingBlockEntity
extends BlockEntity {
    private static final String POT_MIMIC_TAG = "pot_mimic";
    private static final String SPECIES_TAG = "species";
    protected BlockState potState = Blocks.FLOWER_POT.defaultBlockState();
    protected Species species = Species.NULL_SPECIES;

    public PottedSaplingBlockEntity(BlockPos pos, BlockState state) {
        super(DTRegistries.POTTED_SAPLING_BLOCK_ENTITY.get(), pos, state);
    }

    public Species getSpecies() {
        return this.species;
    }

    public void setSpecies(Species species) {
        this.species = species;
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public BlockState getPot() {
        return this.potState;
    }

    public void setPot(BlockState newPotState) {
        this.potState = newPotState.getBlock() instanceof FlowerPotBlock ? newPotState.getBlock().defaultBlockState() : Blocks.FLOWER_POT.defaultBlockState();
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        if (tag.contains(POT_MIMIC_TAG)) {
            Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)tag.getString(POT_MIMIC_TAG)));
            BlockState blockState = this.potState = block != Blocks.AIR ? block.defaultBlockState() : Blocks.FLOWER_POT.defaultBlockState();
        }
        if (tag.contains(SPECIES_TAG)) {
            this.species = Species.findSpecies(tag.getString(SPECIES_TAG));
        }
        super.loadAdditional(tag, registries);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putString(POT_MIMIC_TAG, BuiltInRegistries.BLOCK.getKey((Object)this.potState.getBlock()).toString());
        tag.putString(SPECIES_TAG, this.species.getRegistryName().toString());
    }
}

