/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.block.sapling;

import com.dtteam.dynamictrees.block.sapling.PottedSaplingBlockEntity;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.utility.ItemUtils;
import com.dtteam.dynamictrees.utility.NullUtils;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PottedSaplingBlock
extends BaseEntityBlock {
    protected static final AABB FLOWER_POT_AABB = new AABB(0.3125, 0.0, 0.3125, 0.6875, 0.375, 0.6875);

    public PottedSaplingBlock() {
        super(BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY));
    }

    public Species getSpecies(BlockGetter level, BlockPos pos) {
        return NullUtils.applyIfNonnull(this.getTileEntityPottedSapling(level, pos), PottedSaplingBlockEntity::getSpecies, Species.NULL_SPECIES);
    }

    public boolean setSpecies(Level level, BlockPos pos, BlockState state, Species species) {
        return NullUtils.consumeIfNonnull(this.getTileEntityPottedSapling((BlockGetter)level, pos), pottedSaplingBlockEntity -> pottedSaplingBlockEntity.setSpecies(species));
    }

    public BlockState getPotState(Level level, BlockPos pos) {
        return NullUtils.applyIfNonnull(this.getTileEntityPottedSapling((BlockGetter)level, pos), PottedSaplingBlockEntity::getPot, Blocks.FLOWER_POT.defaultBlockState());
    }

    public boolean setPotState(Level level, BlockState potState, BlockPos pos) {
        return NullUtils.consumeIfNonnull(this.getTileEntityPottedSapling((BlockGetter)level, pos), pottedSaplingBlockEntity -> pottedSaplingBlockEntity.setPot(potState));
    }

    @Nullable
    private PottedSaplingBlockEntity getTileEntityPottedSapling(BlockGetter level, BlockPos pos) {
        BlockEntity tileEntity = level.getBlockEntity(pos);
        return tileEntity instanceof PottedSaplingBlockEntity ? (PottedSaplingBlockEntity)tileEntity : null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return Services.REGISTRY.newPottedSaplingBlockEntity(pPos, pState);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Species species = this.getSpecies((BlockGetter)level, pos);
        if (!species.isValid()) {
            return ItemInteractionResult.FAIL;
        }
        this.removeSaplingFromPot(stack, species, player, level, pos);
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        Species species = this.getSpecies((BlockGetter)level, pos);
        if (!species.isValid()) {
            return InteractionResult.FAIL;
        }
        this.removeSaplingFromPot(ItemStack.EMPTY, species, player, level, pos);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    private boolean removeSaplingFromPot(ItemStack heldStack, Species species, Player player, Level level, BlockPos pos) {
        ItemStack seedStack = species.getSeedStack(1);
        if (heldStack.isEmpty()) {
            player.setItemInHand(InteractionHand.MAIN_HAND, seedStack);
        } else {
            if (heldStack.getItem() == seedStack.getItem()) {
                return false;
            }
            if (!player.addItem(seedStack)) {
                player.drop(seedStack, false);
            }
        }
        level.setBlock(pos, this.getPotState(level, pos), 3);
        return true;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        Species species = this.getSpecies((BlockGetter)level, pos);
        if (species.isValid()) {
            return species.getSeedStack(1);
        }
        return new ItemStack((ItemLike)Items.FLOWER_POT);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        Species species;
        if (target.getType() == HitResult.Type.BLOCK && ((BlockHitResult)target).getDirection() == Direction.UP && (species = this.getSpecies((BlockGetter)level, pos)).isValid()) {
            return species.getSeedStack(1);
        }
        BlockState potState = NullUtils.applyIfNonnull(this.getTileEntityPottedSapling((BlockGetter)level, pos), PottedSaplingBlockEntity::getPot, Blocks.AIR.defaultBlockState());
        if (potState.getBlock() == Blocks.FLOWER_POT) {
            return new ItemStack((ItemLike)Items.FLOWER_POT);
        }
        if (potState.getBlock() instanceof FlowerPotBlock) {
            return new ItemStack((ItemLike)potState.getBlock(), 1);
        }
        return new ItemStack((ItemLike)Items.FLOWER_POT);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.getBlockState(pos.below()).isFaceSturdy((BlockGetter)level, pos, Direction.UP)) {
            this.spawnDrops(level, pos);
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (willHarvest) {
            return true;
        }
        return level.isClientSide() ? level.setBlock(pos, fluid.createLegacyBlock(), 11) : level.removeBlock(pos, false);
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.playerDestroy(level, player, pos, state, te, stack);
        this.spawnDrops(level, pos);
        level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
    }

    public void spawnDrops(Level level, BlockPos pos) {
        ItemUtils.spawnItemStack(level, pos, new ItemStack((ItemLike)Blocks.FLOWER_POT), false);
        if (this.getSpecies((BlockGetter)level, pos) != Species.NULL_SPECIES) {
            ItemUtils.spawnItemStack(level, pos, this.getSpecies((BlockGetter)level, pos).getSeedStack(1), false);
        }
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.create((AABB)FLOWER_POT_AABB);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }
}

