/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.block.leaves;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.api.lazyvalue.MutableLazyValue;
import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.data.DTDataProvider;
import com.dtteam.dynamictrees.data.Generator;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.utility.CoordUtils;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PalmLeavesProperties
extends LeavesProperties {
    public static final TypedRegistry.EntryType<LeavesProperties> TYPE = TypedRegistry.newType(PalmLeavesProperties::new);
    ResourceLocation frondLoader = DynamicTrees.location("large_palm_fronds");
    protected final MutableLazyValue<Generator<DTDataProvider.BlockState, LeavesProperties>> frondsStateGenerator = MutableLazyValue.supplied((Supplier)blockStateGenerators.get(DynamicTrees.location("palm_fronds")));
    public static final String FROND = "frond";
    public static final String CORE_TOP = "core_top";
    public static final String CORE_BOTTOM = "core_bottom";

    public PalmLeavesProperties(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected DynamicLeavesBlock createDynamicLeaves(BlockBehaviour.Properties properties) {
        return new DynamicPalmLeavesBlock(this, properties);
    }

    public void setFrondLoader(ResourceLocation frondLoader) {
        this.frondLoader = frondLoader;
    }

    public ResourceLocation getFrondLoader() {
        return this.frondLoader;
    }

    @Override
    public void generateStateData(DTDataProvider.BlockState provider) {
        this.frondsStateGenerator.get().generate(provider, this);
    }

    public String getFrondsModelName() {
        return "block/palm_leaves/" + this.getRegistryName().getPath() + "_frond";
    }

    public String getCoreTopModelName() {
        return "block/palm_leaves/" + this.getRegistryName().getPath() + "_core_top";
    }

    public String getCoreBottomModelName() {
        return "block/palm_leaves/" + this.getRegistryName().getPath() + "_core_bottom";
    }

    public void addFrondTextures(BiConsumer<String, ResourceLocation> textureConsumer, ResourceLocation leavesTextureLocation) {
        ResourceLocation leavesLoc = this.getTexturePath(FROND).orElse(leavesTextureLocation);
        textureConsumer.accept(FROND, leavesLoc);
    }

    public void addCoreTextures(BiConsumer<String, ResourceLocation> textureConsumer, ResourceLocation coreTextureLocation) {
        ResourceLocation coreLoc = this.getTexturePath(CORE_BOTTOM).orElse(coreTextureLocation);
        textureConsumer.accept(CORE_BOTTOM, coreLoc);
    }

    public ResourceLocation getCoreTopSmartModelLocation() {
        if (this.modelOverrides.containsKey(CORE_TOP)) {
            return (ResourceLocation)this.modelOverrides.get(CORE_TOP);
        }
        return DynamicTrees.location("block/smartmodel/palm/core_top");
    }

    public ResourceLocation getCoreBottomSmartModelLocation() {
        if (this.modelOverrides.containsKey(CORE_BOTTOM)) {
            return (ResourceLocation)this.modelOverrides.get(CORE_BOTTOM);
        }
        return DynamicTrees.location("block/smartmodel/palm/core_bottom");
    }

    public static class DynamicPalmLeavesBlock
    extends DynamicLeavesBlock {
        public static final IntegerProperty DIRECTION = IntegerProperty.create((String)"direction", (int)0, (int)8);
        public static final CoordUtils.Surround[][] hydroSurroundMap = new CoordUtils.Surround[][]{new CoordUtils.Surround[0], {CoordUtils.Surround.NE, CoordUtils.Surround.SE, CoordUtils.Surround.SW, CoordUtils.Surround.NW}, {CoordUtils.Surround.N, CoordUtils.Surround.E, CoordUtils.Surround.S, CoordUtils.Surround.W}, new CoordUtils.Surround[0], new CoordUtils.Surround[0], new CoordUtils.Surround[0], new CoordUtils.Surround[0], new CoordUtils.Surround[0]};

        @Override
        public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
            int dist;
            if (state.getBlock() == this && ((dist = ((Integer)state.getValue((Property)DISTANCE)).intValue()) == 1 || dist == 2) && (Integer)state.getValue((Property)DIRECTION) == 0) {
                level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                return;
            }
            super.randomTick(state, level, pos, rand);
        }

        public DynamicPalmLeavesBlock(LeavesProperties leavesProperties, BlockBehaviour.Properties properties) {
            super(leavesProperties, properties);
            this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)DIRECTION, (Comparable)Integer.valueOf(0)));
        }

        protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
            super.createBlockStateDefinition(builder);
            builder.add(new Property[]{DIRECTION});
        }

        public static BlockState getDirectionState(BlockState state, CoordUtils.Surround surround) {
            if (state == null) {
                return Blocks.AIR.defaultBlockState();
            }
            if (!state.hasProperty((Property)DIRECTION)) {
                return state;
            }
            return (BlockState)state.setValue((Property)DIRECTION, (Comparable)Integer.valueOf(surround == null ? 0 : surround.ordinal() + 1));
        }

        @Override
        public int getRadiusForConnection(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
            return side == Direction.UP && from.getFamily().isCompatibleDynamicLeaves(Species.NULL_SPECIES, state, level, pos) ? fromRadius : 0;
        }

        @Override
        public int branchSupport(BlockState state, BlockGetter level, BranchBlock branch, BlockPos pos, Direction dir, int radius) {
            return branch.getFamily() == this.getFamily(state, level, pos) ? BranchBlock.setSupport(0, 1) : 0;
        }

        @Override
        public boolean appearanceChangesWithHydro(int oldHydro, int newHydro) {
            return true;
        }

        @Override
        public BlockState getLeavesBlockStateForPlacement(LevelAccessor level, BlockPos pos, BlockState leavesStateWithHydro, int oldHydro, boolean worldGen) {
            for (CoordUtils.Surround surround : CoordUtils.Surround.values()) {
                BlockState offstate = level.getBlockState(pos.offset(surround.getOffset()));
                if (offstate.getBlock() != this || (Integer)offstate.getValue((Property)DISTANCE) != 3) continue;
                return DynamicPalmLeavesBlock.getDirectionState(leavesStateWithHydro, surround);
            }
            return leavesStateWithHydro;
        }

        public VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
            AABB base = super.getOcclusionShape(state, level, pos).bounds();
            base.inflate(1.0, 0.0, 1.0);
            base.inflate(-1.0, 0.0, -1.0);
            return Shapes.create((AABB)base);
        }
    }
}

