/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.block.branch;

import com.dtteam.dynamictrees.block.branch.BasicBranchBlock;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.branch.Musable;
import com.dtteam.dynamictrees.block.branch.SurfaceRootBlock;
import com.dtteam.dynamictrees.block.branch.TrunkShellBlock;
import com.dtteam.dynamictrees.block.fruit.FruitBlock;
import com.dtteam.dynamictrees.block.pod.PodBlock;
import com.dtteam.dynamictrees.data.tags.DTBlockTags;
import com.dtteam.dynamictrees.registry.DTRegistries;
import com.dtteam.dynamictrees.systems.BranchConnectables;
import com.dtteam.dynamictrees.tree.ChunkTreeHelper;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.utility.CoordUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ThickBranchBlock
extends BasicBranchBlock
implements Musable {
    public static final int MAX_RADIUS_THICK = 24;
    protected static final IntegerProperty RADIUS_DOUBLE = IntegerProperty.create((String)"radius", (int)1, (int)24);

    public ThickBranchBlock(ResourceLocation name, MapColor mapColor) {
        this(name, BlockBehaviour.Properties.of().mapColor(mapColor));
    }

    public ThickBranchBlock(ResourceLocation name, BlockBehaviour.Properties properties) {
        super(name, properties, RADIUS_DOUBLE, 24);
    }

    public TrunkShellBlock getTrunkShell() {
        return DTRegistries.TRUNK_SHELL.get();
    }

    @Override
    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{RADIUS_DOUBLE}).add(new Property[]{WATERLOGGED});
    }

    @Override
    public int getRadius(BlockState state) {
        if (!(state.getBlock() instanceof ThickBranchBlock)) {
            return super.getRadius(state);
        }
        return this.isSameTree(state) ? Mth.clamp((int)((Integer)state.getValue((Property)RADIUS_DOUBLE)), (int)1, (int)this.getMaxRadius()) : 0;
    }

    @Override
    public int setRadius(LevelAccessor level, BlockPos pos, int radius, @Nullable Direction originDir, int flags) {
        if (this.updateTrunkShells(level, pos, radius, flags)) {
            return super.setRadius(level, pos, radius, originDir, flags);
        }
        return super.setRadius(level, pos, 8, originDir, flags);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.updateTrunkShells((LevelAccessor)level, pos, this.getRadius(state), 6);
        super.neighborChanged(state, level, pos, blockIn, fromPos, isMoving);
    }

    private boolean updateTrunkShells(LevelAccessor level, BlockPos pos, int radius, int flags) {
        if (radius <= 8) {
            return true;
        }
        boolean setable = true;
        ReplaceableState[] repStates = new ReplaceableState[8];
        for (CoordUtils.Surround dir : CoordUtils.Surround.values()) {
            ReplaceableState rep;
            BlockPos dPos = pos.offset(dir.getOffset());
            repStates[dir.ordinal()] = rep = this.getReplaceability(level, dPos, pos);
            if (rep != ReplaceableState.BLOCKING) continue;
            setable = false;
            break;
        }
        if (setable) {
            BlockState trunkState = level.getBlockState(pos);
            boolean isWaterlogged = trunkState.hasProperty((Property)WATERLOGGED) && (Boolean)trunkState.getValue((Property)WATERLOGGED) != false;
            for (CoordUtils.Surround dir : CoordUtils.Surround.values()) {
                boolean replacingWater;
                BlockPos dPos = pos.offset(dir.getOffset());
                ReplaceableState rep = repStates[dir.ordinal()];
                boolean bl = replacingWater = isWaterlogged || level.getBlockState(dPos).getFluidState() == Fluids.WATER.getSource(false);
                if (rep != ReplaceableState.REPLACEABLE) continue;
                level.setBlock(dPos, (BlockState)((BlockState)this.getTrunkShell().defaultBlockState().setValue(TrunkShellBlock.CORE_DIR, (Comparable)((Object)dir.getOpposite()))).setValue((Property)TrunkShellBlock.WATERLOGGED, (Comparable)Boolean.valueOf(replacingWater)), flags);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getRadiusForConnection(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
        if (from instanceof ThickBranchBlock) {
            return this.getRadius(state);
        }
        return Math.min(this.getRadius(state), 8);
    }

    @Override
    protected int getSideConnectionRadius(BlockGetter level, BlockPos pos, int radius, Direction side) {
        BlockPos deltaPos = pos.relative(side);
        BlockState blockState = ChunkTreeHelper.getStateSafe(level, deltaPos);
        if (blockState == null) {
            return 0;
        }
        int connectionRadius = TreeHelper.getTreePart(blockState).getRadiusForConnection(blockState, level, deltaPos, this, side, radius);
        return Math.min(8, connectionRadius);
    }

    public ReplaceableState getReplaceability(LevelAccessor level, BlockPos pos, BlockPos corePos) {
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof TrunkShellBlock) {
            CoordUtils.Surround surr = (CoordUtils.Surround)((Object)state.getValue(TrunkShellBlock.CORE_DIR));
            return pos.offset(surr.getOffset()).equals((Object)corePos) ? ReplaceableState.SHELL : ReplaceableState.BLOCKING;
        }
        if (state.canBeReplaced() || state.is(DTBlockTags.FOLIAGE)) {
            return ReplaceableState.REPLACEABLE;
        }
        if (TreeHelper.isTreePart(block)) {
            return ReplaceableState.TREEPART;
        }
        if (block instanceof SurfaceRootBlock) {
            return ReplaceableState.TREEPART;
        }
        if (BranchConnectables.isBlockConnectable(block)) {
            return ReplaceableState.TREEPART;
        }
        if (block instanceof FruitBlock || block instanceof PodBlock) {
            return ReplaceableState.TREEPART;
        }
        if (this.getFamily().getCommonSpecies().isAcceptableSoilForWorldgen(level, pos, state)) {
            return ReplaceableState.REPLACEABLE;
        }
        return ReplaceableState.BLOCKING;
    }

    @Override
    public int getMaxRadius() {
        return 24;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int thisRadius = this.getRadius(state);
        if (thisRadius <= 8) {
            return super.getShape(state, level, pos, context);
        }
        double radius = (double)thisRadius / 16.0;
        return Shapes.create((AABB)new AABB(0.5 - radius, 0.0, 0.5 - radius, 0.5 + radius, 1.0, 0.5 + radius));
    }

    @Override
    public boolean isMusable(BlockGetter level, BlockState state, BlockPos pos) {
        return this.getRadius(state) > 8;
    }

    static enum ReplaceableState {
        SHELL,
        REPLACEABLE,
        BLOCKING,
        TREEPART;

    }
}

