/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.block;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class BlockWithDynamicHardness
extends Block {
    public BlockWithDynamicHardness(BlockBehaviour.Properties properties) {
        super(properties.destroyTime(2.0f));
        StateDefinition.Builder builder = new StateDefinition.Builder((Object)this);
        this.createBlockStateDefinition(builder);
        this.stateDefinition = builder.create(Block::defaultBlockState, (x$0, x$1, x$2) -> new DynamicHardnessBlockState((Block)x$0, (Reference2ObjectArrayMap<Property<?>, Comparable<?>>)x$1, (MapCodec<BlockState>)x$2));
        this.registerDefaultState((BlockState)this.stateDefinition.any());
    }

    public float getHardness(BlockState state, BlockGetter level, BlockPos pos) {
        return 2.0f;
    }

    public boolean hasTileEntity(BlockState state) {
        return state.getBlock() instanceof EntityBlock;
    }

    protected final class DynamicHardnessBlockState
    extends BlockState {
        public DynamicHardnessBlockState(Block block, Reference2ObjectArrayMap<Property<?>, Comparable<?>> propertiesToValueMap, MapCodec<BlockState> codec) {
            super(block, propertiesToValueMap, codec);
        }

        public float getDestroySpeed(BlockGetter level, BlockPos pos) {
            return BlockWithDynamicHardness.this.getHardness(this, level, pos);
        }

        public boolean hasBlockEntity() {
            return BlockWithDynamicHardness.this.hasTileEntity(this);
        }
    }
}

