/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.api.worldgen;

import com.dtteam.dynamictrees.worldgen.OverworldGroundFinder;
import com.dtteam.dynamictrees.worldgen.SubterraneanGroundFinder;
import com.dtteam.dynamictrees.worldgen.SurfaceGroundFinder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface GroundFinder {
    public static final GroundFinder OVERWORLD = new OverworldGroundFinder();
    public static final GroundFinder SURFACE = new SurfaceGroundFinder();
    public static final GroundFinder SUBTERRANEAN = new SubterraneanGroundFinder();
    public static final Map<ResourceKey<Level>, GroundFinder> GROUND_FINDERS = new ConcurrentHashMap<ResourceKey<Level>, GroundFinder>();

    public List<BlockPos> findGround(LevelAccessor var1, BlockPos var2, @Nullable Heightmap.Types var3);

    public static void registerGroundFinder(ResourceKey<Level> dimension, GroundFinder groundFinder) {
        GROUND_FINDERS.put(dimension, groundFinder);
    }

    public static GroundFinder getGroundFinder(Level level) {
        return GROUND_FINDERS.computeIfAbsent((ResourceKey<Level>)level.dimension(), k -> level.dimensionType().hasCeiling() ? SUBTERRANEAN : OVERWORLD);
    }
}

