/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.api.registry;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.api.registry.ConcurrentRegistry;
import com.dtteam.dynamictrees.api.registry.RegistryEntry;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.utility.ResourceLocationUtils;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public abstract class RegistryHandler
extends RegistryEntry<RegistryHandler> {
    public static final ConcurrentRegistry<RegistryHandler> REGISTRY = new ConcurrentRegistry<RegistryHandler>(RegistryHandler.class, Services.REGISTRY.newRegistryHandler(), true);

    public RegistryHandler(ResourceLocation modId) {
        super(modId);
    }

    public RegistryHandler() {
        this(DynamicTrees.NULL);
    }

    public static RegistryHandler get(String modId) {
        return (RegistryHandler)REGISTRY.get(ResourceLocation.fromNamespaceAndPath((String)modId, (String)modId));
    }

    public static RegistryHandler getOrCorrected(String modId) {
        RegistryHandler handler = RegistryHandler.get(modId);
        return handler.isValid() ? handler : RegistryHandler.get("dynamictrees");
    }

    public static ResourceLocation correctRegistryName(ResourceLocation registryName) {
        if (!RegistryHandler.get(registryName.getNamespace()).isValid()) {
            registryName = ResourceLocationUtils.namespace(registryName, "dynamictrees");
        }
        return registryName;
    }

    public static <T extends Block> Supplier<T> addBlock(ResourceLocation registryName, Supplier<T> blockSup) {
        registryName = RegistryHandler.correctRegistryName(registryName);
        return RegistryHandler.get(registryName.getNamespace()).putBlock(registryName, blockSup);
    }

    public static <T extends Item> Supplier<T> addItem(ResourceLocation registryName, Supplier<T> itemSup) {
        registryName = RegistryHandler.correctRegistryName(registryName);
        return RegistryHandler.get(registryName.getNamespace()).putItem(registryName, itemSup);
    }

    @Nullable
    public abstract Supplier<Block> getBlock(ResourceLocation var1);

    @Nullable
    public abstract Supplier<Item> getItem(ResourceLocation var1);

    public abstract <T extends Block> Supplier<T> putBlock(ResourceLocation var1, Supplier<T> var2);

    public abstract <T extends Item> Supplier<T> putItem(ResourceLocation var1, Supplier<T> var2);
}

