/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees;

import com.dtteam.dynamictrees.api.registry.RegistryHandler;
import com.dtteam.dynamictrees.loot.DTLoot;
import com.dtteam.dynamictrees.systems.season.SeasonCompatibilityHandler;
import com.dtteam.dynamictrees.treepack.Resources;
import com.dtteam.dynamictrees.worldgen.feature.DynamicTreeFeature;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicTrees {
    public static final String MOD_ID = "dynamictrees";
    public static final String MOD_NAME = "Dynamic Trees";
    public static final Logger LOG = LoggerFactory.getLogger((String)"Dynamic Trees");
    public static final String MINECRAFT = "minecraft";
    public static final String SERENE_SEASONS = "sereneseasons";
    public static final String FAST_LEAF_DECAY = "fastleafdecay";
    public static final String PASSABLE_FOLIAGE = "passablefoliage";
    public static final String DYNAMIC_TREES_PLUS = "dynamictreesplus";
    public static final ResourceLocation NULL = DynamicTrees.location("null");
    public static final ResourceLocation OAK = DynamicTrees.location("oak");
    public static final ResourceLocation BIRCH = DynamicTrees.location("birch");
    public static final ResourceLocation SPRUCE = DynamicTrees.location("spruce");
    public static final ResourceLocation JUNGLE = DynamicTrees.location("jungle");
    public static final ResourceLocation DARK_OAK = DynamicTrees.location("dark_oak");
    public static final ResourceLocation ACACIA = DynamicTrees.location("acacia");
    public static final ResourceLocation AZALEA = DynamicTrees.location("azalea");
    public static final ResourceLocation CRIMSON = DynamicTrees.location("crimson");
    public static final ResourceLocation WARPED = DynamicTrees.location("warped");
    private static final List<Runnable> SETUP_HANDLERS = new ArrayList<Runnable>();

    public static void init() {
        SeasonCompatibilityHandler.registerBuiltInSeasonManagers();
    }

    public static void runOnCommonSetup(Runnable handler) {
        SETUP_HANDLERS.add(handler);
    }

    public static void commonSetup() {
        DTLoot.load();
        DynamicTreeFeature.setup();
        RegistryHandler.REGISTRY.clear();
        Resources.MANAGER.setup();
        SETUP_HANDLERS.forEach(Runnable::run);
    }

    public static ResourceLocation location(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }

    public static enum DestroyMode {
        IGNORE,
        SLOPPY,
        SET_RADIUS,
        HARVEST,
        ROT,
        OVERFLOW;

    }

    public static enum AxeDamage {
        VANILLA,
        THICKNESS,
        VOLUME;

    }
}

