/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.neoforge.integration.apotheosis;

import dev.shadowsoffire.apothic_enchanting.ApothicEnchanting;
import dev.shadowsoffire.apothic_enchanting.table.EnchantingStatRegistry;
import fuzs.enchantinginfuser.world.item.enchantment.EnchantingBehavior;
import fuzs.enchantinginfuser.world.level.block.InfuserType;
import java.util.Collection;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;

public final class ApotheosisEnchantingBehavior
implements EnchantingBehavior {
    public static final EnchantingBehavior INSTANCE = new ApotheosisEnchantingBehavior();

    private ApotheosisEnchantingBehavior() {
    }

    @Override
    public Collection<String> getScalingNamespaces() {
        return Set.of("minecraft", "apothic_enchanting");
    }

    @Override
    public int getEnchantmentPowerLimit(InfuserType infuserType) {
        return 50;
    }

    @Override
    public float getEnchantmentPower(BlockState state, Level level, BlockPos pos) {
        return EnchantingStatRegistry.getEterna((BlockState)state, (LevelReader)level, (BlockPos)pos);
    }

    @Override
    public float getEnchantmentPowerLimitScale(BlockState state, Level level, BlockPos pos) {
        return EnchantingStatRegistry.getMaxEterna((BlockState)state, (LevelReader)level, (BlockPos)pos) / 15.0f;
    }

    @Override
    public float getMaximumCostMultiplier() {
        return 2.5f;
    }

    @Override
    public int getMaxLevel(Holder<Enchantment> enchantment) {
        return ApothicEnchanting.getEnchInfo(enchantment).getMaxLevel();
    }

    @Override
    public int getMinCost(Holder<Enchantment> enchantment, int level) {
        return ApothicEnchanting.getEnchInfo(enchantment).getMinPower(level);
    }

    @Override
    public int getMaxCost(Holder<Enchantment> enchantment, int level) {
        return ApothicEnchanting.getEnchInfo(enchantment).getMaxPower(level);
    }
}

