/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.client.util;

import fuzs.enchantinginfuser.world.item.enchantment.EnchantingBehavior;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.Nullable;

public class EnchantmentTooltipHelper {
    public static final String KEY_INCOMPATIBLE_ENCHANTMENTS = "gui.enchantinginfuser.tooltip.incompatible";
    public static final Component UNKNOWN_ENCHANT_COMPONENT = Component.translatable((String)"gui.enchantinginfuser.tooltip.unknown_enchantment").withStyle(ChatFormatting.GRAY);
    public static final Component INCREASE_LEVEL_COMPONENT = Component.translatable((String)"gui.enchantinginfuser.tooltip.lowPower1").withStyle(ChatFormatting.GRAY);
    public static final Component MODIFY_LEVEL_COMPONENT = Component.translatable((String)"gui.enchantinginfuser.tooltip.lowPower2").withStyle(ChatFormatting.GRAY);
    public static final String KEY_CURRENT_ENCHANTING_POWER = "gui.enchantinginfuser.tooltip.current_enchanting_power";

    public static List<Component> getWeakPowerTooltip(int currentPower, int requiredPower, Component component) {
        ArrayList<Component> lines = new ArrayList<Component>();
        MutableComponent currentPowerComponent = Component.literal((String)String.valueOf(currentPower)).withStyle(ChatFormatting.RED);
        MutableComponent requiredPowerComponent = Component.literal((String)String.valueOf(requiredPower));
        lines.add((Component)Component.translatable((String)KEY_CURRENT_ENCHANTING_POWER, (Object[])new Object[]{currentPowerComponent, requiredPowerComponent}));
        lines.add(component);
        return lines;
    }

    public static List<Component> getIncompatibleEnchantmentsTooltip(Collection<Holder<Enchantment>> incompatibleEnchantments) {
        MutableComponent component = Component.translatable((String)KEY_INCOMPATIBLE_ENCHANTMENTS, (Object[])new Object[]{incompatibleEnchantments.stream().map(EnchantmentTooltipHelper::getDisplayName).reduce((o1, o2) -> o1.append(", ").append((Component)o2)).orElse(Component.empty()).withStyle(ChatFormatting.GRAY)});
        return Collections.singletonList(component);
    }

    public static List<Component> getEnchantmentTooltip(Holder<Enchantment> enchantment) {
        ArrayList<Component> lines = new ArrayList<Component>();
        lines.add((Component)Component.empty().append(((Enchantment)enchantment.value()).description()).append(CommonComponents.SPACE).append(EnchantmentTooltipHelper.getLevelComponent(enchantment)));
        String translationKey = EnchantmentTooltipHelper.getEnchantmentDescriptionKey(enchantment);
        if (translationKey != null) {
            lines.add((Component)Component.translatable((String)translationKey).withStyle(ChatFormatting.GRAY));
        }
        return lines;
    }

    private static Component getLevelComponent(Holder<Enchantment> enchantment) {
        int minLevel = ((Enchantment)enchantment.value()).getMinLevel();
        int maxLevel = EnchantingBehavior.get().getMaxLevel(enchantment);
        MutableComponent component = Component.translatable((String)("enchantment.level." + minLevel));
        if (minLevel != maxLevel) {
            component.append("-").append((Component)Component.translatable((String)("enchantment.level." + maxLevel)));
        }
        return EnchantmentTooltipHelper.wrapInRoundBrackets((Component)component).withStyle(ChatFormatting.GRAY);
    }

    static MutableComponent wrapInRoundBrackets(Component component) {
        return Component.literal((String)"(").append(component).append(")");
    }

    @Nullable
    private static String getEnchantmentDescriptionKey(Holder<Enchantment> enchantment) {
        String translationKey = enchantment.unwrapKey().map(resourceKey -> Util.makeDescriptionId((String)resourceKey.registry().getPath(), (ResourceLocation)resourceKey.location())).orElse(null);
        if (translationKey == null) {
            return null;
        }
        if (Language.getInstance().has(translationKey + ".desc")) {
            return translationKey + ".desc";
        }
        if (Language.getInstance().has(translationKey + ".description")) {
            return translationKey + ".description";
        }
        return null;
    }

    public static MutableComponent getDisplayName(Holder<Enchantment> enchantment) {
        return ((Enchantment)enchantment.value()).description().copy();
    }

    public static MutableComponent getDisplayNameWithLevel(Holder<Enchantment> enchantment, int level) {
        MutableComponent component = EnchantmentTooltipHelper.getDisplayName(enchantment);
        if (level != 1 || EnchantingBehavior.get().getMaxLevel(enchantment) != 1) {
            return component.append(CommonComponents.SPACE).append((Component)Component.translatable((String)("enchantment.level." + level)));
        }
        return component;
    }
}

