/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.enchantinginfuser.client.renderer.blockentity.InfuserRenderer;
import fuzs.enchantinginfuser.world.level.block.entity.InfuserBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class InfuserItemRenderer
extends InfuserRenderer {
    private final ItemRenderer itemRenderer;

    public InfuserItemRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.getItemRenderer();
    }

    @Override
    public void render(InfuserBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        super.render(blockEntity, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
        if (blockEntity.open != 0.0f || blockEntity.oOpen != 0.0f) {
            ItemStack itemToEnchant = blockEntity.getItem(0);
            poseStack.pushPose();
            poseStack.translate(0.5f, 1.0f, 0.5f);
            BakedModel model = Minecraft.getInstance().getItemRenderer().getModel(itemToEnchant, blockEntity.getLevel(), null, 0);
            float hoverOffset = Mth.sin((float)(((float)blockEntity.time + partialTick) / 10.0f)) * 0.1f + 0.1f;
            float modelYScale = model.getTransforms().getTransform((ItemDisplayContext)ItemDisplayContext.GROUND).scale.y();
            float openness = Mth.lerp((float)partialTick, (float)blockEntity.oOpen, (float)blockEntity.open);
            poseStack.translate(0.0, (double)(hoverOffset + 0.25f * modelYScale * openness - 0.15f * (1.0f - openness)), 0.0);
            float scale = openness * 0.8f + 0.2f;
            poseStack.scale(scale, scale, scale);
            poseStack.mulPose(Axis.YP.rotation(((float)blockEntity.time + partialTick) / 20.0f));
            this.itemRenderer.render(itemToEnchant, ItemDisplayContext.GROUND, false, poseStack, bufferSource, packedLight, OverlayTexture.NO_OVERLAY, model);
            poseStack.popPose();
        }
    }
}

