/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.client.gui.components;

import com.google.common.collect.Sets;
import fuzs.enchantinginfuser.client.gui.components.InfuserMenuButton;
import fuzs.enchantinginfuser.client.util.EnchantmentTooltipHelper;
import fuzs.enchantinginfuser.util.ModEnchantmentHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.Nullable;

public class InfuserEnchantButton
extends InfuserMenuButton {
    public InfuserEnchantButton(int x, int y, Button.OnPress onPress) {
        super(x, y, 160, 185, onPress);
    }

    @Override
    ChatFormatting getStringColor(int value, boolean mayApply) {
        return value < 0 ? ChatFormatting.YELLOW : (mayApply ? ChatFormatting.GREEN : ChatFormatting.RED);
    }

    @Override
    String getStringValue(int value) {
        return value < 0 ? "+" : String.valueOf(value);
    }

    @Override
    Component getNameComponent(ItemStack itemStack, ItemEnchantments itemEnchantments) {
        boolean isEnchanted = !itemEnchantments.isEmpty();
        itemStack = ModEnchantmentHelper.getEnchantedItemStack(itemStack, isEnchanted);
        return super.getNameComponent(itemStack, itemEnchantments);
    }

    @Override
    Rarity getItemNameRarity(ItemStack itemStack, ItemEnchantments itemEnchantments) {
        boolean isEnchanted = !itemEnchantments.isEmpty();
        itemStack = ModEnchantmentHelper.getEnchantedItemStack(itemStack, isEnchanted);
        RegistryAccess.Frozen registries = Minecraft.getInstance().getConnection().registryAccess();
        return ModEnchantmentHelper.getItemNameRarity((HolderLookup.Provider)registries, itemStack, isEnchanted);
    }

    @Override
    List<FormattedText> getCustomLines(ItemStack itemStack, ItemEnchantments itemEnchantments) {
        ItemEnchantments originalEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)itemStack);
        ArrayList<FormattedText> newLines = new ArrayList<FormattedText>();
        ArrayList<FormattedText> changedLines = new ArrayList<FormattedText>();
        ArrayList<FormattedText> unchangedLines = new ArrayList<FormattedText>();
        ArrayList<FormattedText> removedLines = new ArrayList<FormattedText>();
        this.getEnchantmentLines(itemEnchantments, originalEnchantments, newLines, changedLines, unchangedLines, removedLines);
        ArrayList<FormattedText> lines = new ArrayList<FormattedText>();
        lines.addAll(newLines);
        lines.addAll(changedLines);
        lines.addAll(unchangedLines);
        lines.addAll(removedLines);
        return lines;
    }

    private void getEnchantmentLines(ItemEnchantments itemEnchantments, ItemEnchantments originalEnchantments, List<FormattedText> newLines, List<FormattedText> changedLines, List<FormattedText> unchangedLines, List<FormattedText> removedLines) {
        RegistryAccess.Frozen registries = Minecraft.getInstance().getConnection().registryAccess();
        HolderSet holderSet = InfuserEnchantButton.getTagOrEmpty((HolderLookup.Provider)registries, Registries.ENCHANTMENT, EnchantmentTags.TOOLTIP_ORDER);
        for (Holder enchantment : holderSet) {
            this.addEnchantmentLine(itemEnchantments, originalEnchantments, newLines, changedLines, unchangedLines, removedLines, (Holder<Enchantment>)enchantment);
        }
        for (Holder enchantment : Sets.union((Set)itemEnchantments.keySet(), (Set)originalEnchantments.keySet())) {
            if (holderSet.contains(enchantment)) continue;
            this.addEnchantmentLine(itemEnchantments, originalEnchantments, newLines, changedLines, unchangedLines, removedLines, (Holder<Enchantment>)enchantment);
        }
    }

    private void addEnchantmentLine(ItemEnchantments itemEnchantments, ItemEnchantments originalEnchantments, List<FormattedText> newLines, List<FormattedText> changedLines, List<FormattedText> unchangedLines, List<FormattedText> removedLines, Holder<Enchantment> enchantment) {
        int oldLevel = originalEnchantments.getLevel(enchantment);
        int newLevel = itemEnchantments.getLevel(enchantment);
        if (newLevel > 0 && oldLevel == 0) {
            MutableComponent component = EnchantmentTooltipHelper.getDisplayNameWithLevel(enchantment, newLevel);
            newLines.add((FormattedText)component.withStyle(ChatFormatting.GREEN));
        } else if (newLevel == 0 && oldLevel > 0) {
            MutableComponent component = EnchantmentTooltipHelper.getDisplayNameWithLevel(enchantment, oldLevel);
            removedLines.add((FormattedText)component.withStyle(ChatFormatting.RED));
        } else if (newLevel > 0 && newLevel != oldLevel) {
            MutableComponent component = EnchantmentTooltipHelper.getDisplayName(enchantment);
            MutableComponent changeComponent = Component.translatable((String)"gui.enchantinginfuser.tooltip.change", (Object[])new Object[]{Component.translatable((String)("enchantment.level." + oldLevel)), Component.translatable((String)("enchantment.level." + newLevel))});
            changedLines.add((FormattedText)component.append(CommonComponents.SPACE).append((Component)changeComponent).withStyle(ChatFormatting.YELLOW));
        } else if (newLevel > 0) {
            MutableComponent component = EnchantmentTooltipHelper.getDisplayNameWithLevel(enchantment, newLevel);
            unchangedLines.add((FormattedText)component.withStyle(ChatFormatting.GRAY));
        }
    }

    static <T> HolderSet<T> getTagOrEmpty(HolderLookup.Provider registries, ResourceKey<Registry<T>> registryKey, TagKey<T> key) {
        Optional optional = registries.lookupOrThrow(registryKey).get(key);
        return optional.map(holders -> holders).orElseGet(() -> HolderSet.direct((Holder[])new Holder[0]));
    }

    @Override
    @Nullable
    Component getLevelsComponent(int value, boolean mayApply) {
        if (mayApply && value < 0) {
            return Component.translatable((String)"gui.enchantinginfuser.tooltip.points").withStyle(ChatFormatting.GRAY);
        }
        return super.getLevelsComponent(value, mayApply);
    }
}

