/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.enchantinginfuser.client.gui.screens.inventory.EnchantmentComponent;
import fuzs.enchantinginfuser.client.gui.screens.inventory.InfuserScreen;
import fuzs.enchantinginfuser.client.util.EnchantmentTooltipHelper;
import fuzs.puzzleslib.api.client.gui.v2.components.SpritelessImageButton;
import fuzs.puzzleslib.api.client.gui.v2.components.tooltip.TooltipBuilder;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public abstract class EnchantingOperationButton
extends SpritelessImageButton {
    public EnchantingOperationButton(EnchantmentComponent enchantmentComponent, int x, int y, int xTexOffset, Button.OnPress onPress) {
        super(x, y, 18, 18, 220 + xTexOffset, 0, InfuserScreen.INFUSER_LOCATION, onPress);
        this.visible = !enchantmentComponent.isNotAvailable() && this.getVisibleValue(enchantmentComponent);
        this.active = this.getActiveValue(enchantmentComponent);
        Component component = this.getTooltipComponent(enchantmentComponent);
        if (component != null) {
            TooltipBuilder.create(enchantmentComponent.getWeakPowerTooltip(component)).splitLines().build((AbstractWidget)this);
        }
        this.setTextureLayout(LEGACY_TEXTURE_LAYOUT);
    }

    protected abstract boolean getVisibleValue(EnchantmentComponent var1);

    protected abstract boolean getActiveValue(EnchantmentComponent var1);

    @Nullable
    protected abstract Component getTooltipComponent(EnchantmentComponent var1);

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isActive() && Screen.hasShiftDown()) {
            RenderSystem.enableDepthTest();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
            int yImage = this.isHoveredOrFocused() ? 2 : 1;
            guiGraphics.blit(this.resourceLocation, this.getX() + 3, this.getY(), (float)this.xTexStart, (float)(this.yTexStart + yImage * this.yDiffTex), this.width, this.height, this.textureWidth, this.textureHeight);
            guiGraphics.blit(this.resourceLocation, this.getX() - 3, this.getY(), (float)this.xTexStart, (float)(this.yTexStart + yImage * this.yDiffTex), this.width, this.height, this.textureWidth, this.textureHeight);
        } else {
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.isHoveredOrFocused() && this.getTooltip() != null) {
            InfuserScreen.setIsPowerTooLow(true);
        }
    }

    public static class Remove
    extends EnchantingOperationButton {
        public Remove(EnchantmentComponent enchantmentComponent, int x, int y, Button.OnPress onPress) {
            super(enchantmentComponent, x, y, 0, onPress);
        }

        @Override
        protected boolean getVisibleValue(EnchantmentComponent enchantmentComponent) {
            return enchantmentComponent.isPresent();
        }

        @Override
        protected boolean getActiveValue(EnchantmentComponent enchantmentComponent) {
            return !enchantmentComponent.isIncompatible() && enchantmentComponent.enchantmentLevel() - 1 < enchantmentComponent.enchantmentValues().availableLevel();
        }

        @Override
        @Nullable
        protected Component getTooltipComponent(EnchantmentComponent enchantmentComponent) {
            if (enchantmentComponent.enchantmentLevel() - 1 >= enchantmentComponent.enchantmentValues().availableLevel() && !enchantmentComponent.isNotAvailable()) {
                return EnchantmentTooltipHelper.MODIFY_LEVEL_COMPONENT;
            }
            return null;
        }
    }

    public static class Add
    extends EnchantingOperationButton {
        public Add(EnchantmentComponent enchantmentComponent, int x, int y, Button.OnPress onPress) {
            super(enchantmentComponent, x, y, 18, onPress);
        }

        @Override
        protected boolean getVisibleValue(EnchantmentComponent enchantmentComponent) {
            return enchantmentComponent.enchantmentLevel() < enchantmentComponent.enchantmentValues().maxLevel();
        }

        @Override
        protected boolean getActiveValue(EnchantmentComponent enchantmentComponent) {
            return !enchantmentComponent.isIncompatible() && enchantmentComponent.enchantmentLevel() < enchantmentComponent.enchantmentValues().availableLevel();
        }

        @Override
        @Nullable
        protected Component getTooltipComponent(EnchantmentComponent enchantmentComponent) {
            if (enchantmentComponent.enchantmentLevel() >= enchantmentComponent.enchantmentValues().availableLevel() && !enchantmentComponent.isNotAvailable()) {
                return EnchantmentTooltipHelper.INCREASE_LEVEL_COMPONENT;
            }
            return null;
        }
    }
}

