/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.client.gui.components;

import fuzs.puzzleslib.api.client.gui.v2.screen.ScreenHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public abstract class AbstractMenuSelectionList<E extends ContainerObjectSelectionList.Entry<E>>
extends ContainerObjectSelectionList<E> {
    private static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/creative_inventory/scroller");
    private static final ResourceLocation SCROLLER_DISABLED_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/creative_inventory/scroller_disabled");
    private static final int SCROLLER_WIDTH = 12;
    private static final int SCROLLER_HEIGHT = 15;
    private final int scrollbarOffset;

    public AbstractMenuSelectionList(Minecraft minecraft, int x, int y, int width, int height, int itemHeight, int scrollbarOffset) {
        super(minecraft, width, height, y, itemHeight);
        this.scrollbarOffset = scrollbarOffset;
        this.setX(x);
    }

    protected E getEntryAtPosition(double mouseX, double mouseY) {
        this.headerHeight -= 4;
        ContainerObjectSelectionList.Entry entry = (ContainerObjectSelectionList.Entry)super.getEntryAtPosition(mouseX, mouseY);
        this.headerHeight += 4;
        return (E)entry;
    }

    public int getRowWidth() {
        return this.getWidth();
    }

    protected void renderItem(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int index, int left, int top, int width, int height) {
        super.renderItem(guiGraphics, mouseX, mouseY, partialTick, index, left, top, width, height + 4);
    }

    protected void renderDecorations(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int posX = this.getScrollbarPosition();
        double scrollAmount = this.getMaxScroll() > 0 ? this.getScrollAmount() / (double)this.getMaxScroll() : 0.0;
        int posY = this.getY() + (int)(scrollAmount * (double)(this.getHeight() - 15));
        ResourceLocation resourceLocation = this.getMaxScroll() > 0 ? SCROLLER_SPRITE : SCROLLER_DISABLED_SPRITE;
        guiGraphics.blitSprite(resourceLocation, posX, posY, 12, 15);
    }

    protected boolean scrollbarVisible() {
        return false;
    }

    protected void renderListSeparators(GuiGraphics guiGraphics) {
    }

    protected void renderListBackground(GuiGraphics guiGraphics) {
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - this.getHeight());
    }

    protected int getScrollbarPosition() {
        return this.getRowRight() + this.scrollbarOffset;
    }

    protected void updateScrollingState(double mouseX, double mouseY, int button) {
        this.scrolling = this.isValidClickButton(button) && this.isMouseOverScrollbar(mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isValidMouseClick(button)) {
            return false;
        }
        this.updateScrollingState(mouseX, mouseY, button);
        if (this.scrolling) {
            this.setScrollAmountFromMouse(mouseY);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling) {
            this.setScrollAmountFromMouse(mouseY);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    protected void setScrollAmountFromMouse(double mouseY) {
        double scrollOffs = (mouseY - (double)this.getY() - 7.5) / (double)(this.getHeight() - 15);
        this.setScrollAmount(Mth.clamp((double)scrollOffs, (double)0.0, (double)1.0) * (double)this.getMaxScroll());
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return super.isMouseOver(mouseX, mouseY) || this.isMouseOverScrollbar(mouseX, mouseY);
    }

    protected boolean isMouseOverScrollbar(double mouseX, double mouseY) {
        return ScreenHelper.isHovering((int)this.getScrollbarPosition(), (int)this.getY(), (int)12, (int)this.getHeight(), (double)mouseX, (double)mouseY);
    }

    protected void renderSelection(GuiGraphics guiGraphics, int top, int width, int height, int outerColor, int innerColor) {
    }

    public int getRowLeft() {
        return this.getX();
    }

    protected int getRowTop(int index) {
        return super.getRowTop(index) - 4;
    }
}

