/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.entity;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.render.AzRendererConfig;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.layer.AzRenderLayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class AzEntityRendererConfig<T extends Entity>
extends AzRendererConfig<T> {
    private final Function<T, Float> deathMaxRotationProvider;
    private final Function<T, Float> shadowRadius;

    private AzEntityRendererConfig(Supplier<AzAnimator<T>> animatorProvider, Function<T, Float> deathMaxRotationProvider, Function<T, Float> shadowRadius, Function<T, RenderType> renderTypeFunction, Function<T, ResourceLocation> modelLocationProvider, List<AzRenderLayer<T>> renderLayers, Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> preRenderEntry, Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> postRenderEntry, Function<T, ResourceLocation> textureLocationProvider, Function<T, Float> alphaFunction, Function<T, Float> scaleHeight, Function<T, Float> scaleWidth) {
        super(animatorProvider, modelLocationProvider, renderTypeFunction, renderLayers, preRenderEntry, postRenderEntry, textureLocationProvider, alphaFunction, scaleHeight, scaleWidth);
        this.deathMaxRotationProvider = deathMaxRotationProvider;
        this.shadowRadius = shadowRadius;
    }

    public float getDeathMaxRotation(T entity) {
        return this.deathMaxRotationProvider.apply(entity).floatValue();
    }

    public float shadowRadius(T entity) {
        return this.shadowRadius.apply(entity).floatValue();
    }

    public static <T extends Entity> Builder<T> builder(ResourceLocation modelLocation, ResourceLocation textureLocation) {
        return new Builder<Entity>($ -> modelLocation, $ -> textureLocation);
    }

    public static <T extends Entity> Builder<T> builder(Function<T, ResourceLocation> modelLocationProvider, Function<T, ResourceLocation> textureLocationProvider) {
        return new Builder<T>(modelLocationProvider, textureLocationProvider);
    }

    public static class Builder<T extends Entity>
    extends AzRendererConfig.Builder<T> {
        private Function<T, Float> deathMaxRotationProvider = $ -> Float.valueOf(90.0f);
        protected Function<T, Float> shadowRadius = $ -> Float.valueOf(0.0f);

        public Builder(Function<T, ResourceLocation> modelLocationProvider, Function<T, ResourceLocation> textureLocationProvider) {
            super(modelLocationProvider, textureLocationProvider);
        }

        @Override
        public Builder<T> addRenderLayer(AzRenderLayer<T> renderLayer) {
            return (Builder)super.addRenderLayer(renderLayer);
        }

        public Builder<T> setRenderType(RenderType renderType) {
            this.renderTypeProvider = $ -> renderType;
            return this;
        }

        public Builder<T> setRenderType(Function<T, RenderType> renderTypeProvider) {
            this.renderTypeProvider = renderTypeProvider;
            return this;
        }

        @Override
        public Builder<T> setPrerenderEntry(Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> preRenderEntry) {
            return (Builder)super.setPrerenderEntry(preRenderEntry);
        }

        @Override
        public Builder<T> setPostRenderEntry(Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> preRenderEntry) {
            return (Builder)super.setPostRenderEntry(preRenderEntry);
        }

        @Override
        public Builder<T> setAnimatorProvider(Supplier<@Nullable AzAnimator<T>> animatorProvider) {
            return (Builder)super.setAnimatorProvider(animatorProvider);
        }

        public Builder<T> setDeathMaxRotation(float angle) {
            this.deathMaxRotationProvider = $ -> Float.valueOf(angle);
            return this;
        }

        @Override
        public Builder<T> setAlpha(Function<T, Float> alphaFunction) {
            return (Builder)super.setAlpha(alphaFunction);
        }

        @Override
        public Builder<T> setAlpha(float alpha) {
            return (Builder)super.setAlpha(alpha);
        }

        @Override
        public Builder<T> setScale(Function<T, Float> scaleFunction) {
            return (Builder)super.setScale(scaleFunction);
        }

        @Override
        public Builder<T> setScale(Function<T, Float> scaleHeightFunction, Function<T, Float> scaleWidthFunction) {
            return (Builder)super.setScale(scaleHeightFunction, scaleWidthFunction);
        }

        @Override
        public Builder<T> setScale(float scale) {
            return (Builder)super.setScale(scale);
        }

        @Override
        public Builder<T> setScale(float scaleWidth, float scaleHeight) {
            return (Builder)super.setScale(scaleWidth, scaleHeight);
        }

        public Builder<T> setDeathMaxRotation(Function<T, Float> deathMaxRotationProvider) {
            this.deathMaxRotationProvider = deathMaxRotationProvider;
            return this;
        }

        public Builder<T> setShadowRadius(Function<T, Float> shadowRadiusFunction) {
            this.shadowRadius = shadowRadiusFunction;
            return this;
        }

        public Builder<T> setShadowRadius(float shadowRadius) {
            this.shadowRadius = $ -> Float.valueOf(shadowRadius);
            return this;
        }

        @Override
        public AzEntityRendererConfig<T> build() {
            AzRendererConfig baseConfig = super.build();
            return new AzEntityRendererConfig<Entity>(baseConfig::createAnimator, this.deathMaxRotationProvider, this.shadowRadius, this.renderTypeProvider, baseConfig::modelLocation, baseConfig.renderLayers(), baseConfig::preRenderEntry, baseConfig::postRenderEntry, baseConfig::textureLocation, baseConfig::alpha, baseConfig::scaleHeight, baseConfig::scaleWidth);
        }
    }
}

