/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.armor;

import mod.azure.azurelib.rewrite.animation.impl.AzItemAnimator;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.render.AzProvider;
import mod.azure.azurelib.rewrite.render.AzRendererConfig;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererPipeline;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AzArmorRenderer {
    private final AzProvider<ItemStack> provider = new AzProvider<ItemStack>(config::createAnimator, config::modelLocation);
    private final AzArmorRendererPipeline rendererPipeline;
    @Nullable
    private AzItemAnimator reusedAzItemAnimator;

    public AzArmorRenderer(AzRendererConfig<ItemStack> config) {
        this.rendererPipeline = this.createPipeline(config);
    }

    protected AzArmorRendererPipeline createPipeline(AzRendererConfig config) {
        return new AzArmorRendererPipeline(config, this);
    }

    public void prepForRender(@Nullable Entity entity, ItemStack stack, @Nullable EquipmentSlot slot, @Nullable HumanoidModel<?> baseModel) {
        if (entity == null || slot == null || baseModel == null) {
            return;
        }
        this.rendererPipeline.context().prepare(entity, stack, slot, baseModel);
        AzBakedModel model = this.provider.provideBakedModel(stack);
        this.prepareAnimator(stack, model);
    }

    private void prepareAnimator(ItemStack stack, AzBakedModel model) {
        AzItemAnimator cachedEntityAnimator = (AzItemAnimator)this.provider.provideAnimator(stack);
        if (cachedEntityAnimator != null && model != null) {
            cachedEntityAnimator.setActiveModel(model);
        }
        this.reusedAzItemAnimator = cachedEntityAnimator;
    }

    @Nullable
    public AzItemAnimator animator() {
        return this.reusedAzItemAnimator;
    }

    public AzProvider<ItemStack> provider() {
        return this.provider;
    }

    public AzArmorRendererPipeline rendererPipeline() {
        return this.rendererPipeline;
    }
}

