/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.property.codec;

import mod.azure.azurelib.rewrite.animation.easing.AzEasingType;
import mod.azure.azurelib.rewrite.animation.easing.AzEasingTypeRegistry;
import mod.azure.azurelib.rewrite.animation.easing.AzEasingTypes;
import mod.azure.azurelib.rewrite.animation.property.AzAnimationProperties;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.NotNull;

public class AzAnimationPropertiesCodec
implements StreamCodec<FriendlyByteBuf, AzAnimationProperties> {
    @NotNull
    public AzAnimationProperties decode(FriendlyByteBuf buf) {
        int propertyLength = buf.readByte();
        AzAnimationProperties properties = AzAnimationProperties.EMPTY;
        block5: for (int i = 0; i < propertyLength; ++i) {
            byte code = buf.readByte();
            switch (code) {
                case 0: {
                    properties = properties.withAnimationSpeed(buf.readDouble());
                    continue block5;
                }
                case 1: {
                    properties = properties.withTransitionLength(buf.readFloat());
                    continue block5;
                }
                case 2: {
                    AzEasingType easingType = AzEasingTypeRegistry.getOrDefault(buf.readUtf(), AzEasingTypes.NONE);
                    properties = properties.withEasingType(easingType);
                }
            }
        }
        return properties;
    }

    public void encode(FriendlyByteBuf buf, AzAnimationProperties properties) {
        int propertyLength = 0;
        propertyLength += properties.hasAnimationSpeed() ? 1 : 0;
        propertyLength += properties.hasTransitionLength() ? 1 : 0;
        buf.writeByte(propertyLength += properties.hasEasingType() ? 1 : 0);
        if (properties.hasAnimationSpeed()) {
            buf.writeByte(0);
            buf.writeDouble(properties.animationSpeed());
        }
        if (properties.hasTransitionLength()) {
            buf.writeByte(1);
            buf.writeFloat(properties.transitionLength());
        }
        if (properties.hasEasingType()) {
            buf.writeByte(2);
            buf.writeUtf(properties.easingType().name());
        }
    }
}

