/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.impl;

import mod.azure.azurelib.common.internal.client.util.RenderUtils;
import mod.azure.azurelib.core.molang.MolangParser;
import mod.azure.azurelib.core.molang.MolangQueries;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.animation.AzAnimatorConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public abstract class AzEntityAnimator<T extends Entity>
extends AzAnimator<T> {
    protected AzEntityAnimator() {
    }

    protected AzEntityAnimator(AzAnimatorConfig config) {
        super(config);
    }

    @Override
    protected void applyMolangQueries(T entity, double animTime) {
        super.applyMolangQueries(entity, animTime);
        MolangParser parser = MolangParser.INSTANCE;
        Minecraft minecraft = Minecraft.getInstance();
        parser.setMemoizedValue(MolangQueries.DISTANCE_FROM_CAMERA, () -> minecraft.gameRenderer.getMainCamera().getPosition().distanceTo(entity.position()));
        parser.setMemoizedValue(MolangQueries.IS_ON_GROUND, () -> RenderUtils.booleanToFloat(entity.onGround()));
        parser.setMemoizedValue(MolangQueries.IS_IN_WATER, () -> RenderUtils.booleanToFloat(entity.isInWater()));
        parser.setMemoizedValue(MolangQueries.IS_IN_WATER_OR_RAIN, () -> RenderUtils.booleanToFloat(entity.isInWaterOrRain()));
        parser.setMemoizedValue(MolangQueries.IS_ON_FIRE, () -> RenderUtils.booleanToFloat(entity.isOnFire()));
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            parser.setMemoizedValue(MolangQueries.HEALTH, () -> ((LivingEntity)livingEntity).getHealth());
            parser.setMemoizedValue(MolangQueries.MAX_HEALTH, () -> ((LivingEntity)livingEntity).getMaxHealth());
            parser.setMemoizedValue(MolangQueries.GROUND_SPEED, () -> {
                Vec3 velocity = livingEntity.getDeltaMovement();
                return Mth.sqrt((float)((float)(velocity.x * velocity.x + velocity.z * velocity.z)));
            });
            parser.setMemoizedValue(MolangQueries.YAW_SPEED, () -> livingEntity.getYRot() - livingEntity.yRotO);
        }
    }
}

