/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.core.math;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mod.azure.azurelib.common.internal.common.AzureLibException;
import mod.azure.azurelib.core.math.Constant;
import mod.azure.azurelib.core.math.Group;
import mod.azure.azurelib.core.math.IValue;
import mod.azure.azurelib.core.math.Negate;
import mod.azure.azurelib.core.math.Negative;
import mod.azure.azurelib.core.math.Operation;
import mod.azure.azurelib.core.math.Operator;
import mod.azure.azurelib.core.math.Ternary;
import mod.azure.azurelib.core.math.Variable;
import mod.azure.azurelib.core.math.functions.Function;
import mod.azure.azurelib.core.math.functions.classic.ACos;
import mod.azure.azurelib.core.math.functions.classic.ASin;
import mod.azure.azurelib.core.math.functions.classic.ATan;
import mod.azure.azurelib.core.math.functions.classic.ATan2;
import mod.azure.azurelib.core.math.functions.classic.Abs;
import mod.azure.azurelib.core.math.functions.classic.Cos;
import mod.azure.azurelib.core.math.functions.classic.Exp;
import mod.azure.azurelib.core.math.functions.classic.Ln;
import mod.azure.azurelib.core.math.functions.classic.Mod;
import mod.azure.azurelib.core.math.functions.classic.Pow;
import mod.azure.azurelib.core.math.functions.classic.Sin;
import mod.azure.azurelib.core.math.functions.classic.Sqrt;
import mod.azure.azurelib.core.math.functions.limit.Clamp;
import mod.azure.azurelib.core.math.functions.limit.Max;
import mod.azure.azurelib.core.math.functions.limit.Min;
import mod.azure.azurelib.core.math.functions.rounding.Ceil;
import mod.azure.azurelib.core.math.functions.rounding.Floor;
import mod.azure.azurelib.core.math.functions.rounding.Round;
import mod.azure.azurelib.core.math.functions.rounding.Trunc;
import mod.azure.azurelib.core.math.functions.utility.DieRoll;
import mod.azure.azurelib.core.math.functions.utility.DieRollInteger;
import mod.azure.azurelib.core.math.functions.utility.HermiteBlend;
import mod.azure.azurelib.core.math.functions.utility.Lerp;
import mod.azure.azurelib.core.math.functions.utility.LerpRotate;
import mod.azure.azurelib.core.math.functions.utility.Random;
import mod.azure.azurelib.core.math.functions.utility.RandomInteger;

public class MathBuilder {
    public Map<String, Variable> variables = new HashMap<String, Variable>();
    public Map<String, Class<? extends Function>> functions = new HashMap<String, Class<? extends Function>>();

    public MathBuilder() {
        this.register(new Variable("PI", Math.PI));
        this.register(new Variable("E", Math.E));
        this.functions.put("floor", Floor.class);
        this.functions.put("round", Round.class);
        this.functions.put("ceil", Ceil.class);
        this.functions.put("trunc", Trunc.class);
        this.functions.put("clamp", Clamp.class);
        this.functions.put("max", Max.class);
        this.functions.put("min", Min.class);
        this.functions.put("abs", Abs.class);
        this.functions.put("acos", ACos.class);
        this.functions.put("asin", ASin.class);
        this.functions.put("atan", ATan.class);
        this.functions.put("atan2", ATan2.class);
        this.functions.put("cos", Cos.class);
        this.functions.put("sin", Sin.class);
        this.functions.put("exp", Exp.class);
        this.functions.put("ln", Ln.class);
        this.functions.put("sqrt", Sqrt.class);
        this.functions.put("mod", Mod.class);
        this.functions.put("pow", Pow.class);
        this.functions.put("lerp", Lerp.class);
        this.functions.put("lerprotate", LerpRotate.class);
        this.functions.put("hermite_blend", HermiteBlend.class);
        this.functions.put("die_roll", DieRoll.class);
        this.functions.put("die_roll_integer", DieRollInteger.class);
        this.functions.put("random", Random.class);
        this.functions.put("random_integer", RandomInteger.class);
    }

    public void register(Variable variable) {
        this.variables.put(variable.getName(), variable);
    }

    public IValue parse(String expression) throws Exception {
        return this.parseSymbols(this.breakdownChars(this.breakdown(expression)));
    }

    public String[] breakdown(String expression) throws AzureLibException {
        if (!expression.matches("^[\\w\\d\\s_+-/*%^&|<>=!?:.,()]+$")) {
            throw new AzureLibException("Given expression '" + expression + "' contains illegal characters!");
        }
        expression = expression.replaceAll("\\s+", "");
        String[] chars = expression.split("(?!^)");
        int left = 0;
        int right = 0;
        for (String s : chars) {
            if (s.equals("(")) {
                ++left;
                continue;
            }
            if (!s.equals(")")) continue;
            ++right;
        }
        if (left != right) {
            throw new AzureLibException("Given expression '" + expression + "' has more uneven amount of parenthesis, there are " + left + " open and " + right + " closed!");
        }
        return chars;
    }

    public List<Object> breakdownChars(String[] chars) {
        ArrayList<Object> symbols = new ArrayList<Object>();
        Object buffer = "";
        int len = chars.length;
        block0: for (int i = 0; i < len; ++i) {
            boolean longOperator;
            Object s = chars[i];
            boolean bl = longOperator = i > 0 && this.isOperator(chars[i - 1] + (String)s);
            if (this.isOperator((String)s) || longOperator || ((String)s).equals(",")) {
                if (((String)s).equals("-")) {
                    boolean isOperatorBehind;
                    int size = symbols.size();
                    boolean isFirst = size == 0 && ((String)buffer).isEmpty();
                    boolean bl2 = isOperatorBehind = size > 0 && (this.isOperator(symbols.get(size - 1)) || symbols.get(size - 1).equals(",")) && ((String)buffer).isEmpty();
                    if (isFirst || isOperatorBehind) {
                        buffer = (String)buffer + (String)s;
                        continue;
                    }
                }
                if (longOperator) {
                    s = chars[i - 1] + (String)s;
                    buffer = ((String)buffer).substring(0, ((String)buffer).length() - 1);
                }
                if (!((String)buffer).isEmpty()) {
                    symbols.add(buffer);
                    buffer = "";
                }
                symbols.add(s);
                continue;
            }
            if (((String)s).equals("(")) {
                if (!((String)buffer).isEmpty()) {
                    symbols.add(buffer);
                    buffer = "";
                }
                int counter = 1;
                for (int j = i + 1; j < len; ++j) {
                    String c = chars[j];
                    if (c.equals("(")) {
                        ++counter;
                    } else if (c.equals(")")) {
                        --counter;
                    }
                    if (counter == 0) {
                        symbols.add(this.breakdownChars(((String)buffer).split("(?!^)")));
                        i = j;
                        buffer = "";
                        continue block0;
                    }
                    buffer = (String)buffer + c;
                }
                continue;
            }
            buffer = (String)buffer + (String)s;
        }
        if (!((String)buffer).isEmpty()) {
            symbols.add(buffer);
        }
        return symbols;
    }

    public IValue parseSymbols(List<Object> symbols) throws Exception {
        int lastOp;
        IValue ternary = this.tryTernary(symbols);
        if (ternary != null) {
            return ternary;
        }
        int size = symbols.size();
        if (size == 1) {
            return this.valueFromObject(symbols.get(0));
        }
        if (size == 2) {
            Object first = symbols.get(0);
            Object second = symbols.get(1);
            if ((this.isVariable(first) || first.equals("-")) && second instanceof List) {
                return this.createFunction((String)first, (List)second);
            }
        }
        int op = lastOp = this.seekLastOperator(symbols);
        while (op != -1) {
            int leftOp = this.seekLastOperator(symbols, op - 1);
            if (leftOp != -1) {
                Operation left = this.operationForOperator((String)symbols.get(leftOp));
                Operation right = this.operationForOperator((String)symbols.get(op));
                if (right.value > left.value) {
                    IValue leftValue = this.parseSymbols(symbols.subList(0, leftOp));
                    IValue rightValue = this.parseSymbols(symbols.subList(leftOp + 1, size));
                    return new Operator(left, leftValue, rightValue);
                }
                if (left.value > right.value) {
                    Operation initial = this.operationForOperator((String)symbols.get(lastOp));
                    if (initial.value < left.value) {
                        IValue leftValue = this.parseSymbols(symbols.subList(0, lastOp));
                        IValue rightValue = this.parseSymbols(symbols.subList(lastOp + 1, size));
                        return new Operator(initial, leftValue, rightValue);
                    }
                    IValue leftValue = this.parseSymbols(symbols.subList(0, op));
                    IValue rightValue = this.parseSymbols(symbols.subList(op + 1, size));
                    return new Operator(right, leftValue, rightValue);
                }
            }
            op = leftOp;
        }
        Operation operation = this.operationForOperator((String)symbols.get(lastOp));
        return new Operator(operation, this.parseSymbols(symbols.subList(0, lastOp)), this.parseSymbols(symbols.subList(lastOp + 1, size)));
    }

    protected int seekLastOperator(List<Object> symbols) {
        return this.seekLastOperator(symbols, symbols.size() - 1);
    }

    protected int seekLastOperator(List<Object> symbols, int offset) {
        for (int i = offset; i >= 0; --i) {
            Object o = symbols.get(i);
            if (!this.isOperator(o)) continue;
            return i;
        }
        return -1;
    }

    protected int seekFirstOperator(List<Object> symbols) {
        return this.seekFirstOperator(symbols, 0);
    }

    protected int seekFirstOperator(List<Object> symbols, int offset) {
        int size = symbols.size();
        for (int i = offset; i < size; ++i) {
            Object o = symbols.get(i);
            if (!this.isOperator(o)) continue;
            return i;
        }
        return -1;
    }

    protected IValue tryTernary(List<Object> symbols) throws Exception {
        int question = -1;
        int questions = 0;
        int colon = -1;
        int colons = 0;
        int size = symbols.size();
        for (int i = 0; i < size; ++i) {
            Object object = symbols.get(i);
            if (!(object instanceof String)) continue;
            if (object.equals("?")) {
                if (question == -1) {
                    question = i;
                }
                ++questions;
                continue;
            }
            if (!object.equals(":")) continue;
            if (colons + 1 == questions && colon == -1) {
                colon = i;
            }
            ++colons;
        }
        if (questions == colons && question > 0 && question + 1 < colon && colon < size - 1) {
            return new Ternary(this.parseSymbols(symbols.subList(0, question)), this.parseSymbols(symbols.subList(question + 1, colon)), this.parseSymbols(symbols.subList(colon + 1, size)));
        }
        return null;
    }

    protected IValue createFunction(String first, List<Object> args) throws Exception {
        if (first.equals("!")) {
            return new Negate(this.parseSymbols(args));
        }
        if (first.startsWith("!") && first.length() > 1) {
            return new Negate(this.createFunction(first.substring(1), args));
        }
        if (first.equals("-")) {
            return new Negative(new Group(this.parseSymbols(args)));
        }
        if (first.startsWith("-") && first.length() > 1) {
            return new Negative(this.createFunction(first.substring(1), args));
        }
        if (!this.functions.containsKey(first)) {
            throw new AzureLibException("Function '" + first + "' couldn't be found!");
        }
        ArrayList<IValue> values = new ArrayList<IValue>();
        ArrayList<Object> buffer = new ArrayList<Object>();
        for (Object o : args) {
            if (o.equals(",")) {
                values.add(this.parseSymbols(buffer));
                buffer.clear();
                continue;
            }
            buffer.add(o);
        }
        if (!buffer.isEmpty()) {
            values.add(this.parseSymbols(buffer));
        }
        Class<? extends Function> function = this.functions.get(first);
        Constructor<? extends Function> ctor = function.getConstructor(IValue[].class, String.class);
        return ctor.newInstance(values.toArray(new IValue[values.size()]), first);
    }

    public IValue valueFromObject(Object object) throws Exception {
        if (object instanceof List) {
            return new Group(this.parseSymbols((List)object));
        }
        if (object instanceof String) {
            String symbol = (String)object;
            if (symbol.startsWith("!")) {
                return new Negate(this.valueFromObject(symbol.substring(1)));
            }
            if (this.isDecimal(symbol)) {
                return new Constant(Double.parseDouble(symbol));
            }
            if (this.isVariable(symbol)) {
                if (symbol.startsWith("-")) {
                    Variable value = this.getVariable(symbol = symbol.substring(1));
                    if (value != null) {
                        return new Negative(value);
                    }
                } else {
                    Variable value = this.getVariable(symbol);
                    if (value != null) {
                        return value;
                    }
                }
            }
        }
        throw new AzureLibException("Given object couldn't be converted to value! " + String.valueOf(object));
    }

    protected Variable getVariable(String name) {
        return this.variables.get(name);
    }

    protected Operation operationForOperator(String op) throws AzureLibException {
        for (Operation operation : Operation.values()) {
            if (!operation.sign.equals(op)) continue;
            return operation;
        }
        throw new AzureLibException("There is no such operator '" + op + "'!");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isVariable(Object o) {
        if (!(o instanceof String)) return false;
        String string = (String)o;
        if (this.isDecimal((String)o)) return false;
        if (this.isOperator(string)) return false;
        return true;
    }

    protected boolean isOperator(Object o) {
        String string;
        return o instanceof String && this.isOperator(string = (String)o);
    }

    protected boolean isOperator(String s) {
        return Operation.OPERATORS.contains(s) || s.equals("?") || s.equals(":");
    }

    protected boolean isDecimal(String s) {
        return s.matches("^-?\\d+(\\.\\d+)?$");
    }
}

