/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.internal.client.config.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import mod.azure.azurelib.common.internal.common.config.value.EnumValue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class EnumWidget<E extends Enum<E>>
extends AbstractWidget {
    private static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.parse((String)"widget/button"), ResourceLocation.parse((String)"widget/button_disabled"), ResourceLocation.parse((String)"widget/button_highlighted"));
    private final EnumValue<E> value;

    public EnumWidget(int x, int y, int w, int h, EnumValue<E> value) {
        super(x, y, w, h, CommonComponents.EMPTY);
        this.value = value;
        this.updateText();
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.getInstance();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        graphics.blitSprite(SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderString(graphics, minecraft.font, Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }

    private void renderString(GuiGraphics graphics, Font font, int color) {
        this.renderScrollingString(graphics, font, 2, color);
    }

    public void onClick(double p_230982_1_, double p_230982_3_) {
        this.nextValue();
        this.updateText();
    }

    public void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
    }

    private void nextValue() {
        Enum e = (Enum)this.value.get();
        Enum[] values = (Enum[])e.getDeclaringClass().getEnumConstants();
        int i = e.ordinal();
        int j = (i + 1) % values.length;
        Enum next = values[j];
        this.value.set(next);
    }

    private void updateText() {
        Enum e = (Enum)this.value.get();
        this.setMessage((Component)Component.literal((String)e.name()));
    }
}

