/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container;

import cy.jdkdigital.productivebees.common.block.PoweredCentrifuge;
import cy.jdkdigital.productivebees.common.block.entity.PoweredCentrifugeBlockEntity;
import cy.jdkdigital.productivebees.container.CentrifugeContainer;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PoweredCentrifugeContainer
extends CentrifugeContainer {
    public final PoweredCentrifugeBlockEntity tileEntity;

    public PoweredCentrifugeContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, PoweredCentrifugeContainer.getTileEntity(playerInventory, data));
    }

    public PoweredCentrifugeContainer(int windowId, Inventory playerInventory, final PoweredCentrifugeBlockEntity tileEntity) {
        super((MenuType)ModContainerTypes.POWERED_CENTRIFUGE.get(), windowId, playerInventory, tileEntity);
        this.tileEntity = tileEntity;
        this.addDataSlot(new DataSlot(this){

            public int get() {
                return tileEntity.energyHandler.getEnergyStored();
            }

            public void set(int value) {
                if (tileEntity.energyHandler.getEnergyStored() > 0) {
                    tileEntity.energyHandler.extractEnergy(tileEntity.energyHandler.getEnergyStored(), false);
                }
                if (value > 0) {
                    tileEntity.energyHandler.receiveEnergy(value, false);
                }
            }
        });
    }

    private static PoweredCentrifugeBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof PoweredCentrifugeBlockEntity) {
            return (PoweredCentrifugeBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(tileAtPos));
    }

    @Override
    public boolean stillValid(@Nonnull Player player) {
        return (Boolean)this.canInteractWithCallable.evaluate((world, pos) -> world.getBlockState(pos).getBlock() instanceof PoweredCentrifuge && player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0, (Object)true);
    }

    @Override
    protected BlockEntity getBlockEntity() {
        return this.tileEntity;
    }
}

