/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container;

import cy.jdkdigital.productivebees.common.block.Feeder;
import cy.jdkdigital.productivebees.common.block.entity.FeederBlockEntity;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import cy.jdkdigital.productivelib.container.AbstractContainer;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class FeederContainer
extends AbstractContainer {
    public final FeederBlockEntity tileEntity;
    private final ContainerLevelAccess canInteractWithCallable;

    public FeederContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, FeederContainer.getTileEntity(playerInventory, data));
    }

    public FeederContainer(int windowId, Inventory playerInventory, FeederBlockEntity tileEntity) {
        super((MenuType)ModContainerTypes.FEEDER.get(), windowId);
        this.tileEntity = tileEntity;
        this.canInteractWithCallable = ContainerLevelAccess.create((Level)tileEntity.getLevel(), (BlockPos)tileEntity.getBlockPos());
        IItemHandler inv = (IItemHandler)this.tileEntity.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, this.tileEntity.getBlockPos(), null);
        if (inv instanceof IItemHandler) {
            IItemHandler itemHandler = inv;
            this.addSlotBox(itemHandler, 0, 62, tileEntity.isDouble() ? 26 : 35, 3, 18, tileEntity.isDouble() ? 2 : 1, 18);
        }
        this.layoutPlayerInventorySlots(playerInventory, 0, 8, 84);
    }

    private static FeederBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof FeederBlockEntity) {
            return (FeederBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(tileAtPos));
    }

    public boolean stillValid(@Nonnull Player player) {
        return (Boolean)this.canInteractWithCallable.evaluate((world, pos) -> world.getBlockState(pos).getBlock() instanceof Feeder && player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0, (Object)true);
    }

    protected BlockEntity getBlockEntity() {
        return this.tileEntity;
    }
}

