/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.compat.jei.ingredients;

import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredient;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.compat.jei.ProductiveBeesJeiPlugin;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class BeeIngredientHelper
implements IIngredientHelper<BeeIngredient> {
    @Nonnull
    public IIngredientType<BeeIngredient> getIngredientType() {
        return ProductiveBeesJeiPlugin.BEE_INGREDIENT;
    }

    @Nonnull
    public String getDisplayName(BeeIngredient beeIngredient) {
        Object name = beeIngredient.getBeeEntity().getDescription().getString();
        CompoundTag nbt = BeeReloadListener.INSTANCE.getData(beeIngredient.getBeeType());
        if (nbt != null) {
            name = Component.translatable((String)("entity.productivebees." + ProductiveBee.getBeeName(beeIngredient.getBeeType()) + "_bee")).toString();
            if (!nbt.getString("group").isEmpty()) {
                name = (String)name + " (" + nbt.getString("group") + ")";
            }
        }
        return name;
    }

    @Nonnull
    public String getUniqueId(BeeIngredient beeIngredient, UidContext uidContext) {
        return beeIngredient.getBeeType().toString();
    }

    public String getDisplayModId(BeeIngredient ingredient) {
        return ingredient.getBeeType().getNamespace();
    }

    public ResourceLocation getResourceLocation(BeeIngredient ingredient) {
        return ingredient.getBeeType();
    }

    @Nonnull
    public BeeIngredient copyIngredient(BeeIngredient beeIngredient) {
        return new BeeIngredient(beeIngredient.getBeeEntity(), beeIngredient.getBeeType());
    }

    @Nonnull
    public String getErrorInfo(@Nullable BeeIngredient beeIngredient) {
        if (beeIngredient == null) {
            return "beeingredient:null";
        }
        if (beeIngredient.getBeeEntity() == null) {
            return "beeingredient:bee_null";
        }
        return beeIngredient.getBeeType().toString();
    }
}

