/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.compat.jei;

import cy.jdkdigital.productivebees.client.helper.RecipeHelper;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredient;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredientFactory;
import cy.jdkdigital.productivebees.common.recipe.AdvancedBeehiveRecipe;
import cy.jdkdigital.productivebees.common.recipe.BeeBreedingRecipe;
import cy.jdkdigital.productivebees.common.recipe.BeeConversionRecipe;
import cy.jdkdigital.productivebees.common.recipe.BeeFishingRecipe;
import cy.jdkdigital.productivebees.common.recipe.BeeFloweringRecipe;
import cy.jdkdigital.productivebees.common.recipe.BeeSpawningRecipe;
import cy.jdkdigital.productivebees.common.recipe.BlockConversionRecipe;
import cy.jdkdigital.productivebees.common.recipe.BottlerRecipe;
import cy.jdkdigital.productivebees.common.recipe.CentrifugeRecipe;
import cy.jdkdigital.productivebees.common.recipe.ConfigurableHoneycombRecipe;
import cy.jdkdigital.productivebees.common.recipe.IncubationRecipe;
import cy.jdkdigital.productivebees.common.recipe.ItemConversionRecipe;
import cy.jdkdigital.productivebees.compat.jei.AdvancedBeehiveRecipeCategory;
import cy.jdkdigital.productivebees.compat.jei.BeeBreedingRecipeCategory;
import cy.jdkdigital.productivebees.compat.jei.BeeConversionRecipeCategory;
import cy.jdkdigital.productivebees.compat.jei.BeeFishingRecipeCategory;
import cy.jdkdigital.productivebees.compat.jei.BeeFloweringRecipeCategory;
import cy.jdkdigital.productivebees.compat.jei.BeeSpawningRecipeCategory;
import cy.jdkdigital.productivebees.compat.jei.BlockConversionRecipeCategory;
import cy.jdkdigital.productivebees.compat.jei.BottlerRecipeCategory;
import cy.jdkdigital.productivebees.compat.jei.CentrifugeRecipeCategory;
import cy.jdkdigital.productivebees.compat.jei.HeatedCentrifugeRecipeCategory;
import cy.jdkdigital.productivebees.compat.jei.IncubationRecipeCategory;
import cy.jdkdigital.productivebees.compat.jei.ItemConversionRecipeCategory;
import cy.jdkdigital.productivebees.compat.jei.ingredients.BeeIngredientHelper;
import cy.jdkdigital.productivebees.compat.jei.ingredients.BeeIngredientRenderer;
import cy.jdkdigital.productivebees.container.gui.BottlerScreen;
import cy.jdkdigital.productivebees.container.gui.BreedingChamberScreen;
import cy.jdkdigital.productivebees.container.gui.CentrifugeScreen;
import cy.jdkdigital.productivebees.container.gui.IncubatorScreen;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModDataComponents;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.util.BeeCreator;
import cy.jdkdigital.productivebees.util.BeeHelper;
import cy.jdkdigital.productivebees.util.GeneGroup;
import cy.jdkdigital.productivelib.common.recipe.TagOutputRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class ProductiveBeesJeiPlugin
implements IModPlugin {
    private static final ResourceLocation pluginId = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"productivebees");
    public static final RecipeType<AdvancedBeehiveRecipe> ADVANCED_BEEHIVE_TYPE = RecipeType.create((String)"productivebees", (String)"advanced_beehive", AdvancedBeehiveRecipe.class);
    public static final RecipeType<BeeBreedingRecipe> BEE_BREEDING_TYPE = RecipeType.create((String)"productivebees", (String)"bee_breeding", BeeBreedingRecipe.class);
    public static final RecipeType<BeeConversionRecipe> BEE_CONVERSION_TYPE = RecipeType.create((String)"productivebees", (String)"bee_conversion", BeeConversionRecipe.class);
    public static final RecipeType<BeeFishingRecipe> BEE_FISHING_TYPE = RecipeType.create((String)"productivebees", (String)"bee_fishing", BeeFishingRecipe.class);
    public static final RecipeType<BeeSpawningRecipe> BEE_SPAWNING_TYPE = RecipeType.create((String)"productivebees", (String)"bee_spawning", BeeSpawningRecipe.class);
    public static final RecipeType<CentrifugeRecipe> CENTRIFUGE_TYPE = RecipeType.create((String)"productivebees", (String)"centrifuge", CentrifugeRecipe.class);
    public static final RecipeType<CentrifugeRecipe> BLOCK_CENTRIFUGE_TYPE = RecipeType.create((String)"productivebees", (String)"block_centrifuge", CentrifugeRecipe.class);
    public static final RecipeType<BeeFloweringRecipe> BEE_FLOWERING_TYPE = RecipeType.create((String)"productivebees", (String)"bee_flowering", BeeFloweringRecipe.class);
    public static final RecipeType<IncubationRecipe> INCUBATION_TYPE = RecipeType.create((String)"productivebees", (String)"incubation", IncubationRecipe.class);
    public static final RecipeType<BlockConversionRecipe> BLOCK_CONVERSION_TYPE = RecipeType.create((String)"productivebees", (String)"block_conversion", BlockConversionRecipe.class);
    public static final RecipeType<ItemConversionRecipe> ITEM_CONVERSION_TYPE = RecipeType.create((String)"productivebees", (String)"item_conversion", ItemConversionRecipe.class);
    public static final RecipeType<BottlerRecipe> BOTTLER_TYPE = RecipeType.create((String)"productivebees", (String)"bottler", BottlerRecipe.class);
    public static final IIngredientType<BeeIngredient> BEE_INGREDIENT = () -> BeeIngredient.class;

    public ProductiveBeesJeiPlugin() {
        BeeIngredientFactory.getOrCreateList();
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return pluginId;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.HIVES.get("advanced_oak_beehive").get()), new RecipeType[]{ADVANCED_BEEHIVE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CENTRIFUGE.get()), new RecipeType[]{CENTRIFUGE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.POWERED_CENTRIFUGE.get()), new RecipeType[]{CENTRIFUGE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.HEATED_CENTRIFUGE.get()), new RecipeType[]{CENTRIFUGE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.HEATED_CENTRIFUGE.get()), new RecipeType[]{BLOCK_CENTRIFUGE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.COARSE_DIRT_NEST.get()), new RecipeType[]{BEE_SPAWNING_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.INCUBATOR.get()), new RecipeType[]{INCUBATION_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.BOTTLER.get()), new RecipeType[]{BOTTLER_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.BREEDING_CHAMBER.get()), new RecipeType[]{BEE_BREEDING_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.FEEDER.get()), new RecipeType[]{ITEM_CONVERSION_TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new AdvancedBeehiveRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BeeBreedingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BeeConversionRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CentrifugeRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new HeatedCentrifugeRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BeeFishingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BeeSpawningRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BeeFloweringRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new IncubationRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BlockConversionRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ItemConversionRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BottlerRecipeCategory(guiHelper)});
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        Collection<BeeIngredient> ingredients = BeeIngredientFactory.getOrCreateList(true).values();
        registration.register(BEE_INGREDIENT, new ArrayList<BeeIngredient>(ingredients), (IIngredientHelper)new BeeIngredientHelper(), (IIngredientRenderer)new BeeIngredientRenderer());
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)ModItems.CONFIGURABLE_SPAWN_EGG.get(), (ISubtypeInterpreter)new ISubtypeInterpreter<ItemStack>(this){

            @Nullable
            public Object getSubtypeData(ItemStack ingredient, UidContext context) {
                return ingredient.get(DataComponents.ENTITY_DATA);
            }

            public String getLegacyStringSubtypeInfo(ItemStack ingredient, UidContext context) {
                return ((CustomData)ingredient.get(DataComponents.ENTITY_DATA)).getUnsafe().get("type").toString();
            }
        });
        registration.registerSubtypeInterpreter((Item)ModItems.GENE.get(), (ISubtypeInterpreter)new ISubtypeInterpreter<ItemStack>(this){

            @Nullable
            public Object getSubtypeData(ItemStack ingredient, UidContext context) {
                return ingredient.get(ModDataComponents.GENE_GROUP);
            }

            public String getLegacyStringSubtypeInfo(ItemStack ingredient, UidContext context) {
                return ((GeneGroup)ingredient.get(ModDataComponents.GENE_GROUP)).value();
            }
        });
        registration.registerSubtypeInterpreter((Item)ModItems.CONFIGURABLE_HONEYCOMB.get(), (ISubtypeInterpreter)new ISubtypeInterpreter<ItemStack>(this){

            @Nullable
            public Object getSubtypeData(ItemStack ingredient, UidContext context) {
                return ingredient.get(ModDataComponents.BEE_TYPE);
            }

            public String getLegacyStringSubtypeInfo(ItemStack ingredient, UidContext context) {
                return ((ResourceLocation)ingredient.get(ModDataComponents.BEE_TYPE)).toString();
            }
        });
        registration.registerSubtypeInterpreter((Item)ModItems.CONFIGURABLE_COMB_BLOCK.get(), (ISubtypeInterpreter)new ISubtypeInterpreter<ItemStack>(this){

            @Nullable
            public Object getSubtypeData(ItemStack ingredient, UidContext context) {
                return ingredient.get(ModDataComponents.BEE_TYPE);
            }

            public String getLegacyStringSubtypeInfo(ItemStack ingredient, UidContext context) {
                return ((ResourceLocation)ingredient.get(ModDataComponents.BEE_TYPE)).toString();
            }
        });
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        List advancedBeehiveRecipesMap = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.ADVANCED_BEEHIVE_TYPE.get());
        registration.addRecipes(ADVANCED_BEEHIVE_TYPE, advancedBeehiveRecipesMap.stream().map(RecipeHolder::value).toList());
        List centrifugeRecipesMap = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.CENTRIFUGE_TYPE.get());
        registration.addRecipes(CENTRIFUGE_TYPE, centrifugeRecipesMap.stream().map(RecipeHolder::value).toList());
        List<CentrifugeRecipe> blockCentrifugeRecipesMap = centrifugeRecipesMap.stream().map(recipe -> {
            ItemStack item = ((CentrifugeRecipe)recipe.value()).ingredient.getItems()[0];
            if (item.getItem() instanceof HoneycombItem) {
                ArrayList<TagOutputRecipe.ChancedOutput> outputs = new ArrayList<TagOutputRecipe.ChancedOutput>();
                ((CentrifugeRecipe)recipe.value()).itemOutput.forEach(chanceOutput -> outputs.add(new TagOutputRecipe.ChancedOutput(chanceOutput.ingredient(), chanceOutput.min() * 4, chanceOutput.max() * 4, chanceOutput.chance())));
                SizedFluidIngredient fluid = new SizedFluidIngredient(((CentrifugeRecipe)recipe.value()).fluidOutput.ingredient(), ((CentrifugeRecipe)recipe.value()).fluidOutput.amount() * 4);
                return new CentrifugeRecipe(Ingredient.of((ItemStack[])new ItemStack[]{BeeHelper.getCombBlockFromHoneyComb(item)}), outputs, fluid, ((CentrifugeRecipe)recipe.value()).getProcessingTime());
            }
            return null;
        }).filter(Objects::nonNull).toList();
        registration.addRecipes(BLOCK_CENTRIFUGE_TYPE, blockCentrifugeRecipesMap);
        List fishingRecipesMap = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.BEE_FISHING_TYPE.get());
        registration.addRecipes(BEE_FISHING_TYPE, fishingRecipesMap.stream().map(RecipeHolder::value).toList());
        List beeSpawningRecipesMap = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.BEE_SPAWNING_TYPE.get());
        registration.addRecipes(BEE_SPAWNING_TYPE, beeSpawningRecipesMap.stream().map(RecipeHolder::value).toList());
        List beeBreedingRecipeMap = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.BEE_BREEDING_TYPE.get());
        registration.addRecipes(BEE_BREEDING_TYPE, beeBreedingRecipeMap.stream().map(RecipeHolder::value).toList());
        List beeConversionRecipeMap = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.BEE_CONVERSION_TYPE.get());
        registration.addRecipes(BEE_CONVERSION_TYPE, beeConversionRecipeMap.stream().map(RecipeHolder::value).toList());
        List blockConversionRecipeMap = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.BLOCK_CONVERSION_TYPE.get());
        registration.addRecipes(BLOCK_CONVERSION_TYPE, blockConversionRecipeMap.stream().map(RecipeHolder::value).toList());
        List itemConversionRecipeMap = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.ITEM_CONVERSION_TYPE.get());
        registration.addRecipes(ITEM_CONVERSION_TYPE, itemConversionRecipeMap.stream().map(RecipeHolder::value).toList());
        List bottlerRecipeMap = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.BOTTLER_TYPE.get());
        registration.addRecipes(BOTTLER_TYPE, bottlerRecipeMap.stream().map(RecipeHolder::value).toList());
        Map<String, BeeIngredient> beeList = BeeIngredientFactory.getOrCreateList();
        for (Map.Entry<String, BeeIngredient> entry : beeList.entrySet()) {
            MutableComponent description;
            if (!entry.getKey().contains("productivebees")) continue;
            String beeId = entry.getKey().replace("productivebees:", "");
            if (entry.getValue().isConfigurable()) {
                CompoundTag nbt = BeeReloadListener.INSTANCE.getData(entry.getKey());
                if (nbt.contains("description")) {
                    description = Component.translatable((String)nbt.getString("description"));
                } else {
                    description = Component.translatable((String)("productivebees.ingredient.description." + beeId + "_bee"));
                    if (description.getString().equals("productivebees.ingredient.description." + beeId + "_bee")) {
                        description = Component.literal((String)"");
                    }
                }
                if (!nbt.getBoolean("selfbreed")) {
                    description = Component.translatable((String)"productivebees.ingredient.description.selfbreed", (Object[])new Object[]{description.getString()});
                }
            } else {
                description = Component.translatable((String)("productivebees.ingredient.description." + beeId));
                if (beeId.equals("lumber_bee") || beeId.equals("quarry_bee") || beeId.equals("rancher_bee") || beeId.equals("collector_bee") || beeId.equals("hoarder_bee") || beeId.equals("farmer_bee") || beeId.equals("cupid_bee")) {
                    description = Component.translatable((String)"productivebees.ingredient.description.selfbreed", (Object[])new Object[]{description.getString()});
                }
            }
            if (description.getString().isEmpty()) continue;
            registration.addIngredientInfo((Object)entry.getValue(), BEE_INGREDIENT, new Component[]{description});
        }
        registration.addRecipes(BEE_FLOWERING_TYPE, RecipeHelper.getFlowersRecipes(beeList));
        registration.addRecipes(INCUBATION_TYPE, RecipeHelper.getRecipes(beeList).stream().map(RecipeHolder::value).toList());
        List<String> itemInfos = Arrays.asList("inactive_dragon_egg", "dragon_egg_hive", "bumble_bee_nest", "sugar_cane_nest", "slimy_nest", "stone_nest", "sand_nest", "snow_nest", "gravel_nest", "coarse_dirt_nest", "oak_wood_nest", "spruce_wood_nest", "acacia_wood_nest", "dark_oak_wood_nest", "jungle_wood_nest", "birch_wood_nest", "end_stone_nest", "obsidian_nest", "glowstone_nest", "soul_sand_nest", "nether_brick_nest", "nether_quartz_nest");
        for (String itemName : itemInfos) {
            Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)itemName));
            registration.addIngredientInfo((Object)new ItemStack((ItemLike)item), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)("productivebees.ingredient.description." + itemName))});
        }
        ArrayList chipHiveRecipes = new ArrayList();
        BuiltInRegistries.BLOCK.getTagOrEmpty(ModTags.QUARRY).forEach(blockHolder -> {
            Block b = (Block)blockHolder.value();
            if (!b.builtInRegistryHolder().is(ModTags.DUPE_BLACKLIST)) {
                ArrayList<TagOutputRecipe.ChancedOutput> blockItemOutput = new ArrayList<TagOutputRecipe.ChancedOutput>();
                blockItemOutput.add(new TagOutputRecipe.ChancedOutput(Ingredient.of((ItemLike[])new ItemLike[]{b.asItem()}), 1, 1, 1.0f));
                chipHiveRecipes.add(new AdvancedBeehiveRecipe((Supplier<BeeIngredient>)Lazy.of(() -> (BeeIngredient)beeList.get("productivebees:quarry_bee")), blockItemOutput));
            }
        });
        BuiltInRegistries.BLOCK.getTagOrEmpty(ModTags.LUMBER).forEach(blockHolder -> {
            Block b = (Block)blockHolder.value();
            if (!b.builtInRegistryHolder().is(ModTags.DUPE_BLACKLIST)) {
                ArrayList<TagOutputRecipe.ChancedOutput> blockItemOutput = new ArrayList<TagOutputRecipe.ChancedOutput>();
                blockItemOutput.add(new TagOutputRecipe.ChancedOutput(Ingredient.of((ItemLike[])new ItemLike[]{b.asItem()}), 1, 1, 1.0f));
                chipHiveRecipes.add(new AdvancedBeehiveRecipe((Supplier<BeeIngredient>)Lazy.of(() -> (BeeIngredient)beeList.get("productivebees:lumber_bee")), blockItemOutput));
            }
        });
        registration.addRecipes(ADVANCED_BEEHIVE_TYPE, chipHiveRecipes.stream().toList());
        Optional honeycombRecipe = recipeManager.byKey(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"comb_block/configurable_honeycomb"));
        int count = 4;
        if (honeycombRecipe.isPresent()) {
            count = ((ConfigurableHoneycombRecipe)((RecipeHolder)honeycombRecipe.get()).value()).count;
        }
        ArrayList<RecipeHolder> recipes = new ArrayList<RecipeHolder>();
        for (Map.Entry<ResourceLocation, CompoundTag> entry : BeeReloadListener.INSTANCE.getData().entrySet()) {
            ResourceLocation beeType = entry.getKey();
            ResourceLocation idComb = beeType.withPath(p -> p + "_honeycomb");
            ResourceLocation idCombBlock = beeType.withPath(p -> p + "_comb");
            ItemStack comb = new ItemStack((ItemLike)ModItems.CONFIGURABLE_HONEYCOMB.get());
            BeeCreator.setType(beeType, comb);
            NonNullList combInput = NonNullList.create();
            for (int i = 0; i < count; ++i) {
                combInput.add((Object)Ingredient.of((ItemStack[])new ItemStack[]{comb}));
            }
            ItemStack combBlock = new ItemStack((ItemLike)ModItems.CONFIGURABLE_COMB_BLOCK.get());
            BeeCreator.setType(beeType, combBlock);
            NonNullList combBlockInput = NonNullList.create();
            combBlockInput.add((Object)Ingredient.of((ItemStack[])new ItemStack[]{combBlock}));
            recipes.add(new RecipeHolder(idComb, (Recipe)new ShapelessRecipe("", CraftingBookCategory.BUILDING, combBlock, combInput)));
            ItemStack combOutput = comb.copy();
            combOutput.setCount(count);
            recipes.add(new RecipeHolder(idCombBlock, (Recipe)new ShapelessRecipe("", CraftingBookCategory.MISC, combOutput, combBlockInput)));
        }
        registration.addRecipes(RecipeTypes.CRAFTING, recipes);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(CentrifugeScreen.class, 35, 35, 24, 16, new RecipeType[]{CENTRIFUGE_TYPE});
        registration.addRecipeClickArea(BottlerScreen.class, 142, 37, 14, 14, new RecipeType[]{BOTTLER_TYPE});
        registration.addRecipeClickArea(BreedingChamberScreen.class, 72, 14, 45, 22, new RecipeType[]{BEE_BREEDING_TYPE});
        registration.addRecipeClickArea(IncubatorScreen.class, 64, 35, 14, 16, new RecipeType[]{INCUBATION_TYPE});
    }
}

