/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.compat.jei;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.recipe.AdvancedBeehiveRecipe;
import cy.jdkdigital.productivebees.compat.jei.ProductiveBeesJeiPlugin;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivelib.common.recipe.TagOutputRecipe;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class AdvancedBeehiveRecipeCategory
implements IRecipeCategory<AdvancedBeehiveRecipe> {
    private final IDrawable background;
    private final IDrawable icon;

    public AdvancedBeehiveRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/jei/bee_produce_recipe.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 126, 70);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.HIVES.get("advanced_oak_beehive").get()));
    }

    public RecipeType<AdvancedBeehiveRecipe> getRecipeType() {
        return ProductiveBeesJeiPlugin.ADVANCED_BEEHIVE_TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return Component.translatable((String)"jei.productivebees.advanced_beehive");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AdvancedBeehiveRecipe recipe, IFocusGroup focuses) {
        if (recipe.ingredient.get() == null) {
            ProductiveBees.LOGGER.warn("Recipe is missing bee");
            return;
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 7, 27).addIngredient(ProductiveBeesJeiPlugin.BEE_INGREDIENT, (Object)recipe.ingredient.get())).setSlotName("source");
        if (recipe.getRecipeOutputs().size() > 0) {
            int startX = 69;
            int startY = 27;
            int i = 0;
            for (Map.Entry<ItemStack, TagOutputRecipe.ChancedOutput> entry : recipe.getRecipeOutputs().entrySet()) {
                TagOutputRecipe.ChancedOutput countRange = entry.getValue();
                ArrayList innerList = new ArrayList();
                IntStream.range(countRange.min(), countRange.max() + 1).forEach(amount -> {
                    ItemStack newStack = ((ItemStack)entry.getKey()).copy();
                    newStack.setCount(amount);
                    innerList.add(newStack);
                });
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, startX + i % 3 * 18, startY + (int)(Math.floor((float)i / 3.0f) * 18.0)).addItemStacks(innerList)).addTooltipCallback((recipeSlotView, tooltip) -> {
                    float chance = countRange.chance() * 100.0f;
                    tooltip.add(Component.translatable((String)"productivebees.centrifuge.tooltip.chance", (Object[])new Object[]{chance < 1.0f ? "<1%" : chance + "%"}));
                    if (countRange.min() != countRange.max()) {
                        tooltip.add(Component.translatable((String)"productivebees.centrifuge.tooltip.amount", (Object[])new Object[]{countRange.min() + " - " + countRange.max()}));
                    } else {
                        tooltip.add(Component.literal((String)""));
                    }
                }).setSlotName("output" + i);
                ++i;
            }
        }
    }
}

